/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.placeholder;

import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderEvaluator;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderListener;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderPlugin;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public class PlaceholderRegistry {
    private final Plugin plugin;
    private final Map<PlaceholderPlugin, PlaceholderRegister> registers = new HashMap<PlaceholderPlugin, PlaceholderRegister>();

    public PlaceholderRegistry(Plugin plugin) {
        this.plugin = plugin;
    }

    public void registerPlaceholder(PlaceholderPlugin plugin, String placeholder, PlaceholderEvaluator evaluator) {
        PlaceholderRegister register = this.registers.computeIfAbsent(plugin, x$0 -> new PlaceholderRegister((PlaceholderPlugin)((Object)x$0)));
        register.registerPlaceholder(placeholder, evaluator);
    }

    public void unregisterPlaceholder(PlaceholderPlugin plugin, String placeholder, PlaceholderEvaluator evaluator) {
        PlaceholderRegister register = this.registers.get((Object)plugin);
        if (register != null) {
            register.unregisterPlaceholder(placeholder, evaluator);
        }
    }

    private final class PlaceholderRegister {
        private final PlaceholderPlugin plugin;
        private final Map<String, PlaceholderListener> listeners = new HashMap<String, PlaceholderListener>();

        public PlaceholderRegister(PlaceholderPlugin plugin) {
            this.plugin = plugin;
        }

        public void registerPlaceholder(String placeholder, PlaceholderEvaluator evaluator) {
            PlaceholderListener listener = this.listeners.computeIfAbsent(placeholder, key -> this.plugin.registerPlaceholder(PlaceholderRegistry.this.plugin, (String)key));
            listener.addEvaluator(evaluator);
        }

        public void unregisterPlaceholder(String placeholder, PlaceholderEvaluator evaluator) {
            PlaceholderListener listener = this.listeners.get(placeholder);
            if (listener == null) {
                return;
            }
            listener.removeEvaluator(evaluator);
            if (!listener.hasEvaluators()) {
                listener.unregisterListener();
                this.listeners.remove(placeholder);
            }
        }
    }
}

