/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.placeholder;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import ch.njol.skript.Skript;
import io.github.apickledwalrus.skriptplaceholders.placeholder.MVdWPlaceholderAPIListener;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderAPIListener;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public enum PlaceholderPlugin {
    PLACEHOLDER_API("PlaceholderAPI", Skript.classExists((String)"me.clip.placeholderapi.expansion.PlaceholderExpansion")){
        private final char[] illegalCharacters = new char[]{'%', '{', '}', '_'};

        @Override
        @Nullable
        public String validatePrefix(String prefix) {
            if (StringUtils.isBlank((String)prefix)) {
                return "A prefix cannot be blank";
            }
            for (char character : prefix.toCharArray()) {
                for (char illegalCharacter : this.illegalCharacters) {
                    if (character != illegalCharacter) continue;
                    return this.getDisplayName() + " prefixes cannot contain the character '" + character + "'";
                }
            }
            return null;
        }

        @Override
        PlaceholderListener registerPlaceholder(Plugin plugin, String placeholder) {
            PlaceholderAPIListener listener = new PlaceholderAPIListener(plugin, placeholder);
            listener.registerListener();
            return listener;
        }

        @Override
        @Nullable
        public String parsePlaceholder(String placeholder, @Nullable OfflinePlayer player) {
            String value;
            if (placeholder.indexOf(37) == -1) {
                placeholder = "%" + placeholder + "%";
            }
            if ((value = me.clip.placeholderapi.PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)placeholder)).isEmpty() || value.equalsIgnoreCase(placeholder)) {
                return null;
            }
            return value;
        }

        @Override
        public boolean supportsRelationalPlaceholders() {
            return true;
        }

        @Override
        @Nullable
        public String parseRelationalPlaceholder(String placeholder, Player one, Player two) {
            String value;
            if (placeholder.indexOf(37) == -1) {
                placeholder = "%" + placeholder + "%";
            }
            if ((value = me.clip.placeholderapi.PlaceholderAPI.setRelationalPlaceholders((Player)one, (Player)two, (String)placeholder)).isEmpty() || value.equalsIgnoreCase(placeholder)) {
                return null;
            }
            return value;
        }
    }
    ,
    MVDW_PLACEHOLDER_API("MVdWPlaceholderAPI", Skript.classExists((String)"be.maximvdw.placeholderapi.PlaceholderAPI")){

        @Override
        @Nullable
        public String validatePrefix(String prefix) {
            if (StringUtils.isBlank((String)prefix)) {
                return "A placeholder cannot be blank";
            }
            return null;
        }

        @Override
        PlaceholderListener registerPlaceholder(Plugin plugin, String placeholder) {
            MVdWPlaceholderAPIListener listener = new MVdWPlaceholderAPIListener(plugin, placeholder);
            listener.registerListener();
            return listener;
        }

        @Override
        @Nullable
        public String parsePlaceholder(String placeholder, @Nullable OfflinePlayer player) {
            if (placeholder.charAt(0) == '{' && placeholder.charAt(placeholder.length() - 1) == '}') {
                String value = PlaceholderAPI.replacePlaceholders((OfflinePlayer)player, (String)placeholder);
                if (value.isEmpty() || value.equalsIgnoreCase(placeholder)) {
                    return null;
                }
                return value;
            }
            return null;
        }

        @Override
        public boolean supportsRelationalPlaceholders() {
            return false;
        }
    };

    private static final Collection<PlaceholderPlugin> INSTALLED_PLUGINS;
    private final String displayName;
    private final boolean installed;

    public static Collection<PlaceholderPlugin> getInstalledPlugins() {
        return INSTALLED_PLUGINS;
    }

    private PlaceholderPlugin(String displayName, boolean installed) {
        this.displayName = displayName;
        this.installed = installed;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final boolean isInstalled() {
        return this.installed;
    }

    @Nullable
    public abstract String validatePrefix(String var1);

    abstract PlaceholderListener registerPlaceholder(Plugin var1, String var2);

    @Nullable
    public abstract String parsePlaceholder(String var1, @Nullable OfflinePlayer var2);

    public abstract boolean supportsRelationalPlaceholders();

    @Nullable
    public String parseRelationalPlaceholder(String placeholder, Player one, Player two) {
        if (!this.supportsRelationalPlaceholders()) {
            throw new UnsupportedOperationException("The '" + this.getDisplayName() + "' placeholder plugin does not support relational placeholders.");
        }
        throw new RuntimeException("The '" + this.getDisplayName() + "' is missing an implementation for relational placeholders.");
    }

    static {
        INSTALLED_PLUGINS = Arrays.stream(PlaceholderPlugin.values()).filter(PlaceholderPlugin::isInstalled).collect(Collectors.toSet());
    }
}

