/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.placeholder;

import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderEvaluator;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderListener;
import java.util.HashSet;
import java.util.Set;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Relational;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderAPIListener
extends PlaceholderExpansion
implements Relational,
PlaceholderListener {
    private final Plugin plugin;
    private final String prefix;
    private final Set<PlaceholderEvaluator> evaluators = new HashSet<PlaceholderEvaluator>();

    public PlaceholderAPIListener(Plugin plugin, String prefix) {
        this.plugin = plugin;
        this.prefix = prefix;
    }

    @NotNull
    public String getIdentifier() {
        return this.prefix;
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(@Nullable OfflinePlayer player, @NotNull String identifier) {
        for (PlaceholderEvaluator evaluator : this.evaluators) {
            String result = evaluator.evaluate(this.prefix + "_" + identifier, player);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public String onPlaceholderRequest(Player one, Player two, String identifier) {
        for (PlaceholderEvaluator evaluator : this.evaluators) {
            String result = evaluator.evaluateRelational(this.prefix + "_" + identifier, one, two);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void registerListener() {
        this.register();
    }

    @Override
    public void unregisterListener() {
        this.unregister();
    }

    @Override
    public void addEvaluator(PlaceholderEvaluator evaluator) {
        this.evaluators.add(evaluator);
    }

    @Override
    public void removeEvaluator(PlaceholderEvaluator evaluator) {
        this.evaluators.remove(evaluator);
    }

    @Override
    public boolean hasEvaluators() {
        return !this.evaluators.isEmpty();
    }
}

