/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders.placeholder;

import be.maximvdw.placeholderapi.PlaceholderAPI;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderEvaluator;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderListener;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MVdWPlaceholderAPIListener
implements PlaceholderListener {
    private final Plugin plugin;
    private final String placeholder;
    private final Set<PlaceholderEvaluator> evaluators = new HashSet<PlaceholderEvaluator>();
    private boolean isInvalid;

    public MVdWPlaceholderAPIListener(Plugin plugin, String placeholder) {
        this.plugin = plugin;
        this.placeholder = placeholder;
    }

    @Override
    public void registerListener() {
        PlaceholderAPI.registerPlaceholder((Plugin)this.plugin, (String)this.placeholder, event -> {
            if (this.isInvalid) {
                return null;
            }
            Player player = event.getPlayer();
            if (player == null) {
                player = event.getOfflinePlayer();
            }
            for (PlaceholderEvaluator evaluator : this.evaluators) {
                String result = evaluator.evaluate(this.placeholder, (OfflinePlayer)player);
                if (result == null) continue;
                return result;
            }
            return null;
        });
    }

    @Override
    public void unregisterListener() {
        this.isInvalid = true;
    }

    @Override
    public void addEvaluator(PlaceholderEvaluator evaluator) {
        this.evaluators.add(evaluator);
    }

    @Override
    public void removeEvaluator(PlaceholderEvaluator evaluator) {
        this.evaluators.remove(evaluator);
    }

    @Override
    public boolean hasEvaluators() {
        return !this.evaluators.isEmpty();
    }
}

