/*
 * Decompiled with CFR 0.152.
 */
package io.github.apickledwalrus.skriptplaceholders;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Version;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderPlugin;
import io.github.apickledwalrus.skriptplaceholders.placeholder.PlaceholderRegistry;
import java.io.IOException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SkriptPlaceholders
extends JavaPlugin {
    private static SkriptPlaceholders instance;
    private PlaceholderRegistry registry;

    public static SkriptPlaceholders getInstance() {
        if (instance == null) {
            throw new IllegalStateException("skript-placeholders has not been initialized yet.");
        }
        return instance;
    }

    public void onEnable() {
        Plugin skript = this.getServer().getPluginManager().getPlugin("Skript");
        if (skript == null || !skript.isEnabled()) {
            this.getLogger().severe("Could not find Skript. Make sure that you have it installed and that it is properly loaded. Disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Skript.getVersion().isSmallerThan(new Version(new int[]{2, 7, 3}))) {
            this.getLogger().severe("You are running an unsupported version of Skript. Please update to at least Skript 2.7.3. Disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (PlaceholderPlugin.getInstalledPlugins().isEmpty()) {
            this.getLogger().severe("No placeholder plugins were found. Do you have any installed? Disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        instance = this;
        this.registry = new PlaceholderRegistry((Plugin)this);
        try {
            Skript.registerAddon((JavaPlugin)this).loadClasses("io.github.apickledwalrus.skriptplaceholders.skript.elements", new String[0]);
        }
        catch (IOException e) {
            this.getLogger().severe("A severe error occurred while trying to load the addon. Disabling...");
            this.getLogger().severe(e.toString());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        instance = null;
        this.registry = null;
    }

    public PlaceholderRegistry getRegistry() {
        return this.registry;
    }
}

