/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import de.maxhenkel.voicechat.util.Key;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Collection;

public class PlayerStatesPacket
implements Packet<PlayerStatesPacket> {
    public static final Key PLAYER_STATES = Voicechat.compatibility.createNamespacedKey("states");
    private Collection<PlayerState> playerStates;

    public PlayerStatesPacket() {
    }

    public PlayerStatesPacket(Collection<PlayerState> playerStates) {
        this.playerStates = playerStates;
    }

    public Collection<PlayerState> getPlayerStates() {
        return this.playerStates;
    }

    @Override
    public Key getID() {
        return PLAYER_STATES;
    }

    @Override
    public PlayerStatesPacket fromBytes(FriendlyByteBuf buf) {
        int count = buf.readInt();
        this.playerStates = new ArrayList<PlayerState>(count);
        for (int i = 0; i < count; ++i) {
            PlayerState playerState = PlayerState.fromBytes(buf);
            this.playerStates.add(playerState);
        }
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.playerStates.size());
        for (PlayerState state : this.playerStates) {
            state.toBytes(buf);
        }
    }
}

