/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import de.maxhenkel.voicechat.util.Key;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class JoinGroupPacket
implements Packet<JoinGroupPacket> {
    public static final Key SET_GROUP = Voicechat.compatibility.createNamespacedKey("set_group");
    private UUID group;
    @Nullable
    private String password;

    public JoinGroupPacket() {
    }

    public JoinGroupPacket(UUID group, @Nullable String password) {
        this.group = group;
        this.password = password;
    }

    public UUID getGroup() {
        return this.group;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    public Key getID() {
        return SET_GROUP;
    }

    @Override
    public void onPacket(Player player) {
        Voicechat.SERVER.getServer().getGroupManager().onJoinGroupPacket(player, this);
    }

    @Override
    public JoinGroupPacket fromBytes(FriendlyByteBuf buf) {
        this.group = buf.readUUID();
        if (buf.readBoolean()) {
            this.password = buf.readUtf(512);
        }
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUUID(this.group);
        buf.writeBoolean(this.password != null);
        if (this.password != null) {
            buf.writeUtf(this.password, 512);
        }
    }
}

