/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.plugins.impl.GroupImpl;
import de.maxhenkel.voicechat.util.FriendlyByteBuf;
import de.maxhenkel.voicechat.util.Key;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class CreateGroupPacket
implements Packet<CreateGroupPacket> {
    public static final Key CREATE_GROUP = Voicechat.compatibility.createNamespacedKey("create_group");
    private String name;
    @Nullable
    private String password;
    private Group.Type type;

    public CreateGroupPacket() {
    }

    public CreateGroupPacket(String name, @Nullable String password, Group.Type type) {
        this.name = name;
        this.password = password;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public Group.Type getType() {
        return this.type;
    }

    @Override
    public Key getID() {
        return CREATE_GROUP;
    }

    @Override
    public void onPacket(Player player) {
        Voicechat.SERVER.getServer().getGroupManager().onCreateGroupPacket(player, this);
    }

    @Override
    public CreateGroupPacket fromBytes(FriendlyByteBuf buf) {
        this.name = buf.readUtf(24);
        this.password = null;
        if (buf.readBoolean()) {
            this.password = buf.readUtf(24);
        }
        this.type = GroupImpl.TypeImpl.fromInt(buf.readShort());
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUtf(this.name, 24);
        buf.writeBoolean(this.password != null);
        if (this.password != null) {
            buf.writeUtf(this.password, 24);
        }
        buf.writeShort(GroupImpl.TypeImpl.toInt(this.type));
    }
}

