/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.integration.placeholderapi;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.Server;
import javax.annotation.Nullable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VoicechatExpansion
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "voicechat";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", Voicechat.INSTANCE.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return Voicechat.INSTANCE.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String params) {
        if (player == null) {
            return super.onPlaceholderRequest(player, params);
        }
        if (params.equalsIgnoreCase("installed")) {
            return Voicechat.SERVER.isCompatible(player) ? Voicechat.TRANSLATIONS.placeholderVoicechatInstalled.get() : "";
        }
        if (params.equalsIgnoreCase("not_installed")) {
            return !Voicechat.SERVER.isCompatible(player) ? Voicechat.TRANSLATIONS.placeholderVoicechatNotInstalled.get() : "";
        }
        if (params.equalsIgnoreCase("disabled")) {
            Server server = Voicechat.SERVER.getServer();
            if (server == null) {
                return "";
            }
            PlayerState state = server.getPlayerStateManager().getState(player.getUniqueId());
            if (state == null) {
                return "";
            }
            if (!state.isDisabled()) {
                return "";
            }
            return Voicechat.TRANSLATIONS.placeholderVoicechatDisabled.get();
        }
        return super.onPlaceholderRequest(player, params);
    }
}

