/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import de.maxhenkel.voicechat.Voicechat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;

public class BukkitVersion {
    public static final Pattern BUKKIT_VERSION_REGEX = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+))?-R(?<revision>[\\d.-]+)(?:-SNAPSHOT)?$");
    private final int major;
    private final int minor;
    private final int patch;
    private final String revision;

    public BukkitVersion(int major, int minor, int patch, String revision) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.revision = revision;
    }

    private static BukkitVersion fromRegex(Matcher matcher) {
        String major = matcher.group("major");
        String minor = matcher.group("minor");
        String patch = matcher.group("patch");
        String revision = matcher.group("revision");
        if (patch == null || patch.isEmpty()) {
            patch = "0";
        }
        return new BukkitVersion(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch), revision);
    }

    @Nullable
    public static BukkitVersion getVersion() {
        return BukkitVersion.parseBukkitVersion(Bukkit.getBukkitVersion());
    }

    @Nullable
    public static BukkitVersion parseBukkitVersion(String bukkitVersion) {
        Matcher targetMatcher = BUKKIT_VERSION_REGEX.matcher(bukkitVersion);
        if (!targetMatcher.matches()) {
            Voicechat.LOGGER.fatal("Failed to parse target Bukkit version: {}", bukkitVersion);
            return null;
        }
        return BukkitVersion.fromRegex(targetMatcher);
    }

    @Nullable
    public static BukkitVersion getTargetVersion() {
        return BukkitVersion.parseBukkitVersion("1.21.11-R0.1-SNAPSHOT");
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getRevision() {
        return this.revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BukkitVersion that = (BukkitVersion)o;
        if (this.major != that.major) {
            return false;
        }
        if (this.minor != that.minor) {
            return false;
        }
        if (this.patch != that.patch) {
            return false;
        }
        return this.revision.equals(that.revision);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.patch <= 0) {
            return this.major + "." + this.minor + "-R" + this.revision;
        }
        return this.major + "." + this.minor + "." + this.patch + "-R" + this.revision;
    }
}

