/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.utility;

import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import me.lucko.luckperms.lib.bytebuddy.build.AccessControllerPlugin;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.utility.dispatcher.JavaDispatcher;
import me.lucko.luckperms.lib.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@HashCodeAndEqualsPlugin.Enhance
public class QueueFactory {
    private static final QueueFactory INSTANCE = new QueueFactory();
    private final Dispatcher dispatcher = QueueFactory.doPrivileged(JavaDispatcher.of(Dispatcher.class));

    private QueueFactory() {
    }

    public static <T> Queue<T> make() {
        LinkedList queue = QueueFactory.INSTANCE.dispatcher.arrayDeque();
        return queue == null ? new LinkedList() : queue;
    }

    public static <T> Queue<T> make(Collection<? extends T> elements) {
        LinkedList<T> queue = QueueFactory.INSTANCE.dispatcher.arrayDeque(elements);
        return queue == null ? new LinkedList<T>(elements) : queue;
    }

    @AccessControllerPlugin.Enhance
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return action.run();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @JavaDispatcher.Defaults
    @JavaDispatcher.Proxied(value="java.util.ArrayDeque")
    protected static interface Dispatcher {
        @MaybeNull
        @JavaDispatcher.IsConstructor
        public <T> Queue<T> arrayDeque();

        @MaybeNull
        @JavaDispatcher.IsConstructor
        public <T> Queue<T> arrayDeque(Collection<? extends T> var1);
    }
}

