/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.utility;

import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.enumeration.EnumerationDescription;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.StackManipulation;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.constant.ClassConstant;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.member.FieldAccess;
import me.lucko.luckperms.lib.bytebuddy.utility.JavaConstant;
import me.lucko.luckperms.lib.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface ConstantValue {
    public TypeDescription getTypeDescription();

    public StackManipulation toStackManipulation();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Simple
    implements ConstantValue {
        private final StackManipulation stackManipulation;
        private final TypeDescription typeDescription;

        protected Simple(StackManipulation stackManipulation, TypeDescription typeDescription) {
            this.stackManipulation = stackManipulation;
            this.typeDescription = typeDescription;
        }

        public static ConstantValue wrap(Object value) {
            ConstantValue constant = Simple.wrapOrNull(value);
            if (constant == null) {
                throw new IllegalArgumentException("Not a constant value: " + value);
            }
            return constant;
        }

        @MaybeNull
        public static ConstantValue wrapOrNull(Object value) {
            if (value instanceof ConstantValue) {
                return (ConstantValue)value;
            }
            if (value instanceof TypeDescription) {
                return ((TypeDescription)value).isPrimitive() ? new Simple(ClassConstant.of((TypeDescription)value), TypeDescription.ForLoadedType.of(Class.class)) : JavaConstant.Simple.of((TypeDescription)value);
            }
            if (value instanceof EnumerationDescription) {
                return new Simple(FieldAccess.forEnumeration((EnumerationDescription)value), ((EnumerationDescription)value).getEnumerationType());
            }
            if (value instanceof Boolean) {
                return new Simple(IntegerConstant.forValue((Boolean)value), TypeDescription.ForLoadedType.of(Boolean.TYPE));
            }
            if (value instanceof Byte) {
                return new Simple(IntegerConstant.forValue(((Byte)value).byteValue()), TypeDescription.ForLoadedType.of(Byte.TYPE));
            }
            if (value instanceof Short) {
                return new Simple(IntegerConstant.forValue(((Short)value).shortValue()), TypeDescription.ForLoadedType.of(Short.TYPE));
            }
            if (value instanceof Character) {
                return new Simple(IntegerConstant.forValue(((Character)value).charValue()), TypeDescription.ForLoadedType.of(Character.TYPE));
            }
            if (value instanceof Class) {
                return ((Class)value).isPrimitive() ? new Simple(ClassConstant.of(TypeDescription.ForLoadedType.of((Class)value)), TypeDescription.ForLoadedType.of(Class.class)) : JavaConstant.Simple.of(TypeDescription.ForLoadedType.of((Class)value));
            }
            if (value instanceof Enum) {
                return new Simple(FieldAccess.forEnumeration(new EnumerationDescription.ForLoadedEnumeration((Enum)value)), TypeDescription.ForLoadedType.of(((Enum)value).getDeclaringClass()));
            }
            return JavaConstant.Simple.ofLoadedOrNull(value);
        }

        @Override
        public TypeDescription getTypeDescription() {
            return this.typeDescription;
        }

        @Override
        public StackManipulation toStackManipulation() {
            return this.stackManipulation;
        }
    }
}

