/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.utility;

import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.jar.asm.ClassReader;
import me.lucko.luckperms.lib.bytebuddy.jar.asm.ClassVisitor;
import me.lucko.luckperms.lib.bytebuddy.jar.asm.ClassWriter;
import me.lucko.luckperms.lib.bytebuddy.pool.TypePool;
import me.lucko.luckperms.lib.bytebuddy.utility.AsmClassReader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface AsmClassWriter {
    public ClassVisitor getVisitor();

    public byte[] getBinaryRepresentation();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class FrameComputingClassWriter
    extends ClassWriter {
        private final TypePool typePool;

        public FrameComputingClassWriter(int flags, TypePool typePool) {
            super(flags);
            this.typePool = typePool;
        }

        public FrameComputingClassWriter(ClassReader classReader, int flags, TypePool typePool) {
            super(classReader, flags);
            this.typePool = typePool;
        }

        @Override
        protected String getCommonSuperClass(String leftTypeName, String rightTypeName) {
            TypeDescription.Generic superClass;
            TypeDescription rightType;
            TypeDescription leftType = this.typePool.describe(leftTypeName.replace('/', '.')).resolve();
            if (leftType.isAssignableFrom(rightType = this.typePool.describe(rightTypeName.replace('/', '.')).resolve())) {
                return leftType.getInternalName();
            }
            if (leftType.isAssignableTo(rightType)) {
                return rightType.getInternalName();
            }
            if (leftType.isInterface() || rightType.isInterface()) {
                return TypeDescription.ForLoadedType.of(Object.class).getInternalName();
            }
            do {
                if ((superClass = leftType.getSuperClass()) != null) continue;
                return TypeDescription.ForLoadedType.of(Object.class).getInternalName();
            } while (!(leftType = superClass.asErasure()).isAssignableFrom(rightType));
            return leftType.getInternalName();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Default
    implements AsmClassWriter {
        private final ClassWriter classWriter;

        public Default(ClassWriter classWriter) {
            this.classWriter = classWriter;
        }

        @Override
        public ClassVisitor getVisitor() {
            return this.classWriter;
        }

        @Override
        public byte[] getBinaryRepresentation() {
            return this.classWriter.toByteArray();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Factory {
        public AsmClassWriter make(int var1);

        public AsmClassWriter make(int var1, AsmClassReader var2);

        public AsmClassWriter make(int var1, TypePool var2);

        public AsmClassWriter make(int var1, AsmClassReader var2, TypePool var3);

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Suppressing
        implements Factory {
            private final Factory delegate;

            public Suppressing(Factory delegate) {
                this.delegate = delegate;
            }

            @Override
            public AsmClassWriter make(int flags) {
                return this.delegate.make(flags);
            }

            @Override
            public AsmClassWriter make(int flags, AsmClassReader classReader) {
                return this.delegate.make(flags);
            }

            @Override
            public AsmClassWriter make(int flags, TypePool typePool) {
                return this.delegate.make(flags, typePool);
            }

            @Override
            public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                return this.delegate.make(flags, typePool);
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static enum Default implements Factory
        {
            INSTANCE;


            @Override
            public AsmClassWriter make(int flags) {
                return this.make(flags, TypePool.Empty.INSTANCE);
            }

            @Override
            public AsmClassWriter make(int flags, AsmClassReader classReader) {
                return this.make(flags, classReader, TypePool.Empty.INSTANCE);
            }

            @Override
            public AsmClassWriter make(int flags, TypePool typePool) {
                return new me.lucko.luckperms.lib.bytebuddy.utility.AsmClassWriter$Default(new FrameComputingClassWriter(flags, typePool));
            }

            @Override
            public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                ClassReader unwrapped = classReader.unwrap(ClassReader.class);
                return new me.lucko.luckperms.lib.bytebuddy.utility.AsmClassWriter$Default(unwrapped == null ? new FrameComputingClassWriter(flags, typePool) : new FrameComputingClassWriter(unwrapped, flags, typePool));
            }
        }
    }
}

