/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.matcher;

import java.util.Arrays;
import java.util.List;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.field.FieldDescription;
import me.lucko.luckperms.lib.bytebuddy.description.method.MethodDescription;
import me.lucko.luckperms.lib.bytebuddy.description.type.RecordComponentDescription;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.matcher.ElementMatcher;
import me.lucko.luckperms.lib.bytebuddy.matcher.ElementMatchers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface LatentMatcher<T> {
    public ElementMatcher<? super T> resolve(TypeDescription var1);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Disjunction<S>
    implements LatentMatcher<S> {
        private final List<? extends LatentMatcher<? super S>> matchers;

        public Disjunction(LatentMatcher<? super S> ... matcher) {
            this(Arrays.asList(matcher));
        }

        public Disjunction(List<? extends LatentMatcher<? super S>> matchers) {
            this.matchers = matchers;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            ElementMatcher.Junction<Object> matcher = ElementMatchers.none();
            for (LatentMatcher<S> latentMatcher : this.matchers) {
                matcher = matcher.or(latentMatcher.resolve(typeDescription));
            }
            return matcher;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Conjunction<S>
    implements LatentMatcher<S> {
        private final List<? extends LatentMatcher<? super S>> matchers;

        public Conjunction(LatentMatcher<? super S> ... matcher) {
            this(Arrays.asList(matcher));
        }

        public Conjunction(List<? extends LatentMatcher<? super S>> matchers) {
            this.matchers = matchers;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            ElementMatcher.Junction<Object> matcher = ElementMatchers.any();
            for (LatentMatcher<S> latentMatcher : this.matchers) {
                matcher = matcher.and(latentMatcher.resolve(typeDescription));
            }
            return matcher;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForRecordComponentToken
    implements LatentMatcher<RecordComponentDescription> {
        private final RecordComponentDescription.Token token;

        public ForRecordComponentToken(RecordComponentDescription.Token token) {
            this.token = token;
        }

        @Override
        public ElementMatcher<? super RecordComponentDescription> resolve(TypeDescription typeDescription) {
            return ElementMatchers.named(this.token.getName());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForMethodToken
    implements LatentMatcher<MethodDescription> {
        private final MethodDescription.Token token;

        public ForMethodToken(MethodDescription.Token token) {
            this.token = token;
        }

        @Override
        public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
            return new ResolvedMatcher(this.token.asSignatureToken(typeDescription));
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class ResolvedMatcher
        extends ElementMatcher.Junction.ForNonNullValues<MethodDescription> {
            private final MethodDescription.SignatureToken signatureToken;

            protected ResolvedMatcher(MethodDescription.SignatureToken signatureToken) {
                this.signatureToken = signatureToken;
            }

            @Override
            public boolean doMatch(MethodDescription target) {
                return target.asSignatureToken().equals(this.signatureToken);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForFieldToken
    implements LatentMatcher<FieldDescription> {
        private final FieldDescription.Token token;

        public ForFieldToken(FieldDescription.Token token) {
            this.token = token;
        }

        @Override
        public ElementMatcher<? super FieldDescription> resolve(TypeDescription typeDescription) {
            return new ResolvedMatcher(this.token.asSignatureToken(typeDescription));
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class ResolvedMatcher
        extends ElementMatcher.Junction.ForNonNullValues<FieldDescription> {
            private final FieldDescription.SignatureToken signatureToken;

            protected ResolvedMatcher(FieldDescription.SignatureToken signatureToken) {
                this.signatureToken = signatureToken;
            }

            @Override
            protected boolean doMatch(FieldDescription target) {
                return target.asSignatureToken().equals(this.signatureToken);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Resolved<S>
    implements LatentMatcher<S> {
        private final ElementMatcher<? super S> matcher;

        public Resolved(ElementMatcher<? super S> matcher) {
            this.matcher = matcher;
        }

        @Override
        public ElementMatcher<? super S> resolve(TypeDescription typeDescription) {
            return this.matcher;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum ForSelfDeclaredMethod implements LatentMatcher<MethodDescription>
    {
        DECLARED(false),
        NOT_DECLARED(true);

        private final boolean inverted;

        private ForSelfDeclaredMethod(boolean inverted) {
            this.inverted = inverted;
        }

        @Override
        public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
            return this.inverted ? ElementMatchers.not(ElementMatchers.isDeclaredBy(typeDescription)) : ElementMatchers.isDeclaredBy(typeDescription);
        }
    }
}

