/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.matcher;

import java.util.HashSet;
import java.util.Queue;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDefinition;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.matcher.ElementMatcher;
import me.lucko.luckperms.lib.bytebuddy.utility.QueueFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@HashCodeAndEqualsPlugin.Enhance
public class HasSuperTypeMatcher<T extends TypeDescription>
extends ElementMatcher.Junction.ForNonNullValues<T> {
    private final ElementMatcher<? super TypeDescription.Generic> matcher;

    public HasSuperTypeMatcher(ElementMatcher<? super TypeDescription.Generic> matcher) {
        this.matcher = matcher;
    }

    @Override
    protected boolean doMatch(T target) {
        HashSet<TypeDescription> previous = new HashSet<TypeDescription>();
        for (TypeDefinition typeDefinition : target) {
            if (!previous.add(typeDefinition.asErasure())) {
                return false;
            }
            if (this.matcher.matches(typeDefinition.asGenericType())) {
                return true;
            }
            Queue<TypeDescription.Generic> interfaceTypes = QueueFactory.make(typeDefinition.getInterfaces());
            while (!interfaceTypes.isEmpty()) {
                TypeDefinition interfaceType = interfaceTypes.remove();
                if (!previous.add(interfaceType.asErasure())) continue;
                if (this.matcher.matches(interfaceType.asGenericType())) {
                    return true;
                }
                interfaceTypes.addAll(interfaceType.getInterfaces());
            }
        }
        return false;
    }

    public String toString() {
        return "hasSuperType(" + this.matcher + ")";
    }
}

