/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.matcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.utility.nullability.MaybeNull;
import me.lucko.luckperms.lib.bytebuddy.utility.nullability.UnknownNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface ElementMatcher<T> {
    public boolean matches(@UnknownNull T var1);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Junction<S>
    extends ElementMatcher<S> {
        public <U extends S> Junction<U> and(ElementMatcher<? super U> var1);

        public <U extends S> Junction<U> or(ElementMatcher<? super U> var1);

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static abstract class ForNonNullValues<W>
        extends AbstractBase<W> {
            @Override
            public boolean matches(@MaybeNull W target) {
                return target != null && this.doMatch(target);
            }

            protected abstract boolean doMatch(W var1);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Disjunction<W>
        extends AbstractBase<W> {
            private final List<ElementMatcher<? super W>> matchers;

            public Disjunction(ElementMatcher<? super W> ... matcher) {
                this(Arrays.asList(matcher));
            }

            public Disjunction(List<ElementMatcher<? super W>> matchers) {
                this.matchers = new ArrayList<ElementMatcher<? super W>>(matchers.size());
                for (ElementMatcher<W> elementMatcher : matchers) {
                    if (elementMatcher instanceof Disjunction) {
                        this.matchers.addAll(((Disjunction)elementMatcher).matchers);
                        continue;
                    }
                    this.matchers.add(elementMatcher);
                }
            }

            @Override
            public boolean matches(@UnknownNull W target) {
                for (ElementMatcher<W> matcher : this.matchers) {
                    if (!matcher.matches(target)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder("(");
                boolean first = true;
                for (ElementMatcher<? super W> elementMatcher : this.matchers) {
                    if (first) {
                        first = false;
                    } else {
                        stringBuilder.append(" or ");
                    }
                    stringBuilder.append(elementMatcher);
                }
                return stringBuilder.append(")").toString();
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        public static class Conjunction<W>
        extends AbstractBase<W> {
            private final List<ElementMatcher<? super W>> matchers;

            public Conjunction(ElementMatcher<? super W> ... matcher) {
                this(Arrays.asList(matcher));
            }

            public Conjunction(List<ElementMatcher<? super W>> matchers) {
                this.matchers = new ArrayList<ElementMatcher<? super W>>(matchers.size());
                for (ElementMatcher<W> elementMatcher : matchers) {
                    if (elementMatcher instanceof Conjunction) {
                        this.matchers.addAll(((Conjunction)elementMatcher).matchers);
                        continue;
                    }
                    this.matchers.add(elementMatcher);
                }
            }

            @Override
            public boolean matches(@UnknownNull W target) {
                for (ElementMatcher<W> matcher : this.matchers) {
                    if (matcher.matches(target)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder("(");
                boolean first = true;
                for (ElementMatcher<? super W> elementMatcher : this.matchers) {
                    if (first) {
                        first = false;
                    } else {
                        stringBuilder.append(" and ");
                    }
                    stringBuilder.append(elementMatcher);
                }
                return stringBuilder.append(")").toString();
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static abstract class AbstractBase<V>
        implements Junction<V> {
            @Override
            public <U extends V> Junction<U> and(ElementMatcher<? super U> other) {
                return new Conjunction(this, other);
            }

            @Override
            public <U extends V> Junction<U> or(ElementMatcher<? super U> other) {
                return new Disjunction(this, other);
            }
        }
    }
}

