/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.matcher;

import me.lucko.luckperms.lib.bytebuddy.ClassFileVersion;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.matcher.ElementMatcher;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@HashCodeAndEqualsPlugin.Enhance
public class ClassFileVersionMatcher<T extends TypeDescription>
extends ElementMatcher.Junction.ForNonNullValues<T> {
    private final ClassFileVersion classFileVersion;
    private final boolean atMost;

    public ClassFileVersionMatcher(ClassFileVersion classFileVersion, boolean atMost) {
        this.classFileVersion = classFileVersion;
        this.atMost = atMost;
    }

    @Override
    protected boolean doMatch(T target) {
        ClassFileVersion classFileVersion = target.getClassFileVersion();
        return classFileVersion != null && (this.atMost ? classFileVersion.isAtMost(this.classFileVersion) : classFileVersion.isAtLeast(this.classFileVersion));
    }

    public String toString() {
        return "hasClassFileVersion(at " + (this.atMost ? "most" : "least") + " " + this.classFileVersion + ")";
    }
}

