/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.constant;

import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.implementation.Implementation;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.StackManipulation;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.StackSize;
import me.lucko.luckperms.lib.bytebuddy.jar.asm.MethodVisitor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum IntegerConstant implements StackManipulation
{
    MINUS_ONE(2),
    ZERO(3),
    ONE(4),
    TWO(5),
    THREE(6),
    FOUR(7),
    FIVE(8);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private IntegerConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(boolean value) {
        return value ? ONE : ZERO;
    }

    public static StackManipulation forValue(int value) {
        switch (value) {
            case -1: {
                return MINUS_ONE;
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
        }
        if (value >= -128 && value <= 127) {
            return new SingleBytePush((byte)value);
        }
        if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return new TwoBytePush((short)value);
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        SIZE = StackSize.SINGLE.toIncreasingSize();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class ConstantPool
    extends StackManipulation.AbstractBase {
        private final int value;

        protected ConstantPool(int value) {
            this.value = value;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn(this.value);
            return SIZE;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class TwoBytePush
    extends StackManipulation.AbstractBase {
        private final short value;

        protected TwoBytePush(short value) {
            this.value = value;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitIntInsn(17, this.value);
            return SIZE;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    protected static class SingleBytePush
    extends StackManipulation.AbstractBase {
        private final byte value;

        protected SingleBytePush(byte value) {
            this.value = value;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitIntInsn(16, this.value);
            return SIZE;
        }
    }
}

