/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.primitive;

import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.StackManipulation;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveWideningDelegate;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@HashCodeAndEqualsPlugin.Enhance
public class PrimitiveTypeAwareAssigner
implements Assigner {
    private final Assigner referenceTypeAwareAssigner;

    public PrimitiveTypeAwareAssigner(Assigner referenceTypeAwareAssigner) {
        this.referenceTypeAwareAssigner = referenceTypeAwareAssigner;
    }

    @Override
    public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source.isPrimitive() && target.isPrimitive()) {
            return PrimitiveWideningDelegate.forPrimitive(source).widenTo(target);
        }
        if (source.isPrimitive()) {
            return PrimitiveBoxingDelegate.forPrimitive(source).assignBoxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        if (target.isPrimitive()) {
            return PrimitiveUnboxingDelegate.forReferenceType(source).assignUnboxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        return this.referenceTypeAwareAssigner.assign(source, target, typing);
    }
}

