/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.StackManipulation;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveTypeAwareAssigner;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.primitive.VoidAwareAssigner;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.reference.GenericTypeAwareAssigner;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.reference.ReferenceTypeAwareAssigner;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="Safe initialization is implied.")
public interface Assigner {
    public static final Assigner DEFAULT = new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE));
    public static final Assigner GENERICS_AWARE = new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(GenericTypeAwareAssigner.INSTANCE));

    public StackManipulation assign(TypeDescription.Generic var1, TypeDescription.Generic var2, Typing var3);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Refusing implements Assigner
    {
        INSTANCE;


        @Override
        public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Typing typing) {
            return StackManipulation.Illegal.INSTANCE;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum EqualTypesOnly implements Assigner
    {
        GENERIC{

            @Override
            public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Typing typing) {
                return (StackManipulation)((Object)(source.equals(target) ? StackManipulation.Trivial.INSTANCE : StackManipulation.Illegal.INSTANCE));
            }
        }
        ,
        ERASURE{

            @Override
            public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Typing typing) {
                return (StackManipulation)((Object)(source.asErasure().equals(target.asErasure()) ? StackManipulation.Trivial.INSTANCE : StackManipulation.Illegal.INSTANCE));
            }
        };

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Typing {
        STATIC(false),
        DYNAMIC(true);

        private final boolean dynamic;

        private Typing(boolean dynamic) {
            this.dynamic = dynamic;
        }

        public static Typing of(boolean dynamic) {
            return dynamic ? DYNAMIC : STATIC;
        }

        public boolean isDynamic() {
            return this.dynamic;
        }
    }
}

