/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.annotation.AnnotationDescription;
import me.lucko.luckperms.lib.bytebuddy.description.method.MethodDescription;
import me.lucko.luckperms.lib.bytebuddy.description.method.MethodList;
import me.lucko.luckperms.lib.bytebuddy.description.method.ParameterDescription;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.implementation.Implementation;
import me.lucko.luckperms.lib.bytebuddy.implementation.MethodAccessorFactory;
import me.lucko.luckperms.lib.bytebuddy.implementation.bind.MethodDelegationBinder;
import me.lucko.luckperms.lib.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.StackManipulation;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.constant.MethodConstant;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.constant.NullConstant;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.member.FieldAccess;
import me.lucko.luckperms.lib.bytebuddy.jar.asm.MethodVisitor;
import me.lucko.luckperms.lib.bytebuddy.matcher.ElementMatchers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface SuperMethod {
    public boolean cached() default true;

    public boolean privileged() default false;

    public boolean fallbackToDefault() default true;

    public boolean nullIfImpossible() default false;

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<SuperMethod>
    {
        INSTANCE;

        private static final MethodDescription.InDefinedShape CACHED;
        private static final MethodDescription.InDefinedShape PRIVILEGED;
        private static final MethodDescription.InDefinedShape FALLBACK_TO_DEFAULT;
        private static final MethodDescription.InDefinedShape NULL_IF_IMPOSSIBLE;

        @Override
        public Class<SuperMethod> getHandledType() {
            return SuperMethod.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<SuperMethod> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
            if (!target.getType().asErasure().isAssignableFrom(Method.class)) {
                throw new IllegalStateException("Cannot assign Method type to " + target);
            }
            if (source.isMethod()) {
                Implementation.SpecialMethodInvocation specialMethodInvocation = (annotation.getValue(FALLBACK_TO_DEFAULT).resolve(Boolean.class) != false ? implementationTarget.invokeDominant(source.asSignatureToken()) : implementationTarget.invokeSuper(source.asSignatureToken())).withCheckedCompatibilityTo(source.asTypeToken());
                if (specialMethodInvocation.isValid()) {
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(new DelegationMethod(specialMethodInvocation, annotation.getValue(CACHED).resolve(Boolean.class), annotation.getValue(PRIVILEGED).resolve(Boolean.class)));
                }
                if (annotation.getValue(NULL_IF_IMPOSSIBLE).resolve(Boolean.class).booleanValue()) {
                    return new MethodDelegationBinder.ParameterBinding.Anonymous(NullConstant.INSTANCE);
                }
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            if (annotation.getValue(NULL_IF_IMPOSSIBLE).resolve(Boolean.class).booleanValue()) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(NullConstant.INSTANCE);
            }
            return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
        }

        static {
            MethodList<MethodDescription.InDefinedShape> methods = TypeDescription.ForLoadedType.of(SuperMethod.class).getDeclaredMethods();
            CACHED = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("cached"))).getOnly();
            PRIVILEGED = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("privileged"))).getOnly();
            FALLBACK_TO_DEFAULT = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("fallbackToDefault"))).getOnly();
            NULL_IF_IMPOSSIBLE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("nullIfImpossible"))).getOnly();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class DelegationMethod
        implements StackManipulation {
            private final Implementation.SpecialMethodInvocation specialMethodInvocation;
            private final boolean cached;
            private final boolean privileged;

            protected DelegationMethod(Implementation.SpecialMethodInvocation specialMethodInvocation, boolean cached, boolean privileged) {
                this.specialMethodInvocation = specialMethodInvocation;
                this.cached = cached;
                this.privileged = privileged;
            }

            @Override
            public boolean isValid() {
                return this.specialMethodInvocation.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                MethodConstant.CanCache methodConstant = this.privileged ? MethodConstant.ofPrivileged(implementationContext.registerAccessorFor(this.specialMethodInvocation, MethodAccessorFactory.AccessType.PUBLIC)) : MethodConstant.of(implementationContext.registerAccessorFor(this.specialMethodInvocation, MethodAccessorFactory.AccessType.PUBLIC));
                return (this.cached ? FieldAccess.forField(implementationContext.cache(methodConstant, TypeDescription.ForLoadedType.of(Method.class))).read() : methodConstant).apply(methodVisitor, implementationContext);
            }
        }
    }
}

