/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.annotation.AnnotationDescription;
import me.lucko.luckperms.lib.bytebuddy.description.enumeration.EnumerationDescription;
import me.lucko.luckperms.lib.bytebuddy.description.method.MethodDescription;
import me.lucko.luckperms.lib.bytebuddy.description.method.MethodList;
import me.lucko.luckperms.lib.bytebuddy.description.method.ParameterDescription;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.dynamic.TargetType;
import me.lucko.luckperms.lib.bytebuddy.implementation.Implementation;
import me.lucko.luckperms.lib.bytebuddy.implementation.auxiliary.TypeProxy;
import me.lucko.luckperms.lib.bytebuddy.implementation.bind.MethodDelegationBinder;
import me.lucko.luckperms.lib.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.StackManipulation;
import me.lucko.luckperms.lib.bytebuddy.implementation.bytecode.assign.Assigner;
import me.lucko.luckperms.lib.bytebuddy.matcher.ElementMatchers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Super {
    public Instantiation strategy() default Instantiation.CONSTRUCTOR;

    public boolean ignoreFinalizer() default true;

    public boolean serializableProxy() default false;

    public Class<?>[] constructorParameters() default {};

    public Class<? extends ConstructorResolver> constructorResolver() default ConstructorResolver.Default.class;

    public Class<?> proxyType() default void.class;

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Super>
    {
        INSTANCE;

        private static final MethodDescription.InDefinedShape STRATEGY;
        private static final MethodDescription.InDefinedShape PROXY_TYPE;

        @Override
        public Class<Super> getHandledType() {
            return Super.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<Super> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner, Assigner.Typing typing) {
            if (target.getType().isPrimitive() || target.getType().isArray()) {
                throw new IllegalStateException(target + " uses the @Super annotation on an invalid type");
            }
            TypeDescription proxyType = TypeLocator.ForType.of(annotation.getValue(PROXY_TYPE).resolve(TypeDescription.class)).resolve(implementationTarget.getInstrumentedType(), target.getType());
            if (proxyType.isFinal()) {
                throw new IllegalStateException("Cannot extend final type as @Super proxy: " + proxyType);
            }
            if (source.isStatic() || !implementationTarget.getInstrumentedType().isAssignableTo(proxyType)) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(annotation.getValue(STRATEGY).resolve(EnumerationDescription.class).load(Instantiation.class).proxyFor(proxyType, implementationTarget, annotation));
        }

        static {
            MethodList<MethodDescription.InDefinedShape> annotationProperties = TypeDescription.ForLoadedType.of(Super.class).getDeclaredMethods();
            STRATEGY = (MethodDescription.InDefinedShape)((MethodList)annotationProperties.filter(ElementMatchers.named("strategy"))).getOnly();
            PROXY_TYPE = (MethodDescription.InDefinedShape)((MethodList)annotationProperties.filter(ElementMatchers.named("proxyType"))).getOnly();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        protected static interface TypeLocator {
            public TypeDescription resolve(TypeDescription var1, TypeDescription.Generic var2);

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            @HashCodeAndEqualsPlugin.Enhance
            public static class ForType
            implements TypeLocator {
                private final TypeDescription typeDescription;

                protected ForType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                protected static TypeLocator of(TypeDescription typeDescription) {
                    if (typeDescription.represents(Void.TYPE)) {
                        return ForParameterType.INSTANCE;
                    }
                    if (typeDescription.represents((Type)((Object)TargetType.class))) {
                        return ForInstrumentedType.INSTANCE;
                    }
                    if (typeDescription.isPrimitive() || typeDescription.isArray()) {
                        throw new IllegalStateException("Cannot assign proxy to " + typeDescription);
                    }
                    return new ForType(typeDescription);
                }

                @Override
                public TypeDescription resolve(TypeDescription instrumentedType, TypeDescription.Generic parameterType) {
                    if (!this.typeDescription.isAssignableTo(parameterType.asErasure())) {
                        throw new IllegalStateException("Impossible to assign " + this.typeDescription + " to parameter of type " + parameterType);
                    }
                    return this.typeDescription;
                }
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static enum ForParameterType implements TypeLocator
            {
                INSTANCE;


                @Override
                public TypeDescription resolve(TypeDescription instrumentedType, TypeDescription.Generic parameterType) {
                    TypeDescription erasure = parameterType.asErasure();
                    return erasure.equals(instrumentedType) ? instrumentedType : erasure;
                }
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static enum ForInstrumentedType implements TypeLocator
            {
                INSTANCE;


                @Override
                public TypeDescription resolve(TypeDescription instrumentedType, TypeDescription.Generic parameterType) {
                    return instrumentedType;
                }
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Instantiation {
        CONSTRUCTOR{

            @Override
            protected StackManipulation proxyFor(TypeDescription proxyType, Implementation.Target implementationTarget, AnnotationDescription.Loadable<Super> annotation) {
                MethodDescription.InDefinedShape constructor;
                try {
                    ConstructorResolver constructorResolver = (ConstructorResolver)annotation.getValue(CONSTRUCTOR_RESOLVER).load(ConstructorResolver.class.getClassLoader()).resolve(Class.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    constructor = constructorResolver.resolve(proxyType, Arrays.asList((Object[])annotation.getValue(CONSTRUCTOR_PARAMETERS).resolve(TypeDescription[].class)));
                }
                catch (NoSuchMethodException exception) {
                    throw new IllegalStateException("No default constructor specified by " + annotation.getValue(CONSTRUCTOR_RESOLVER).resolve(TypeDescription.class).getName(), exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Failed to resolve constructor specified by " + annotation, exception.getTargetException());
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Failed to resolve constructor specified by " + annotation, exception);
                }
                return new TypeProxy.ForSuperMethodByConstructor(proxyType, constructor, implementationTarget, annotation.getValue(IGNORE_FINALIZER).resolve(Boolean.class), annotation.getValue(SERIALIZABLE_PROXY).resolve(Boolean.class));
            }
        }
        ,
        UNSAFE{

            @Override
            protected StackManipulation proxyFor(TypeDescription proxyType, Implementation.Target implementationTarget, AnnotationDescription.Loadable<Super> annotation) {
                return new TypeProxy.ForSuperMethodByReflectionFactory(proxyType, implementationTarget, annotation.getValue(IGNORE_FINALIZER).resolve(Boolean.class), annotation.getValue(SERIALIZABLE_PROXY).resolve(Boolean.class));
            }
        };

        private static final MethodDescription.InDefinedShape IGNORE_FINALIZER;
        private static final MethodDescription.InDefinedShape SERIALIZABLE_PROXY;
        private static final MethodDescription.InDefinedShape CONSTRUCTOR_PARAMETERS;
        private static final MethodDescription.InDefinedShape CONSTRUCTOR_RESOLVER;

        protected abstract StackManipulation proxyFor(TypeDescription var1, Implementation.Target var2, AnnotationDescription.Loadable<Super> var3);

        static {
            MethodList<MethodDescription.InDefinedShape> annotationProperties = TypeDescription.ForLoadedType.of(Super.class).getDeclaredMethods();
            IGNORE_FINALIZER = (MethodDescription.InDefinedShape)((MethodList)annotationProperties.filter(ElementMatchers.named("ignoreFinalizer"))).getOnly();
            SERIALIZABLE_PROXY = (MethodDescription.InDefinedShape)((MethodList)annotationProperties.filter(ElementMatchers.named("serializableProxy"))).getOnly();
            CONSTRUCTOR_PARAMETERS = (MethodDescription.InDefinedShape)((MethodList)annotationProperties.filter(ElementMatchers.named("constructorParameters"))).getOnly();
            CONSTRUCTOR_RESOLVER = (MethodDescription.InDefinedShape)((MethodList)annotationProperties.filter(ElementMatchers.named("constructorResolver"))).getOnly();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface ConstructorResolver {
        public MethodDescription.InDefinedShape resolve(TypeDescription var1, List<TypeDescription> var2);

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static class Default
        implements ConstructorResolver {
            @Override
            public MethodDescription.InDefinedShape resolve(TypeDescription proxiedType, List<TypeDescription> constructorParameters) {
                if (proxiedType.isInterface()) {
                    return (MethodDescription.InDefinedShape)((MethodList)TypeDescription.ForLoadedType.of(Object.class).getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();
                }
                MethodList candidates = (MethodList)proxiedType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.not(ElementMatchers.isPrivate())).and(ElementMatchers.takesArguments(constructorParameters)));
                if (candidates.size() == 1) {
                    return (MethodDescription.InDefinedShape)candidates.getOnly();
                }
                throw new IllegalStateException("Did not discover exactly one constructor on " + proxiedType + " with parameters " + constructorParameters);
            }
        }
    }
}

