/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.lucko.luckperms.lib.bytebuddy.build.AccessControllerPlugin;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.utility.JavaModule;
import me.lucko.luckperms.lib.bytebuddy.utility.nullability.MaybeNull;
import me.lucko.luckperms.lib.bytebuddy.utility.privilege.SetAccessibleAction;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface LoadedTypeInitializer {
    public void onLoad(Class<?> var1);

    public boolean isAlive();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Serialization is considered opt-in for a rare use case")
    public static class Compound
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final List<LoadedTypeInitializer> loadedTypeInitializers = new ArrayList<LoadedTypeInitializer>();

        public Compound(LoadedTypeInitializer ... loadedTypeInitializer) {
            this(Arrays.asList(loadedTypeInitializer));
        }

        public Compound(List<? extends LoadedTypeInitializer> loadedTypeInitializers) {
            for (LoadedTypeInitializer loadedTypeInitializer : loadedTypeInitializers) {
                if (loadedTypeInitializer instanceof Compound) {
                    this.loadedTypeInitializers.addAll(((Compound)loadedTypeInitializer).loadedTypeInitializers);
                    continue;
                }
                if (loadedTypeInitializer instanceof NoOp) continue;
                this.loadedTypeInitializers.add(loadedTypeInitializer);
            }
        }

        @Override
        public void onLoad(Class<?> type) {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializers) {
                loadedTypeInitializer.onLoad(type);
            }
        }

        @Override
        public boolean isAlive() {
            for (LoadedTypeInitializer loadedTypeInitializer : this.loadedTypeInitializers) {
                if (!loadedTypeInitializer.isAlive()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForStaticField
    implements LoadedTypeInitializer,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String fieldName;
        private final Object value;
        @MaybeNull
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.IGNORE)
        private final transient Object accessControlContext;

        public ForStaticField(String fieldName, Object value) {
            this.fieldName = fieldName;
            this.value = value;
            this.accessControlContext = ForStaticField.getContext();
        }

        @MaybeNull
        @AccessControllerPlugin.Enhance
        private static Object getContext() {
            return null;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> action, @MaybeNull Object context) {
            return action.run();
        }

        private Object readResolve() {
            return new ForStaticField(this.fieldName, this.value);
        }

        @Override
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Modules are assumed available when module system is supported")
        public void onLoad(Class<?> type) {
            try {
                Field field = type.getDeclaredField(this.fieldName);
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers()) || JavaModule.isSupported() && !JavaModule.ofType(type).isExported(TypeDescription.ForLoadedType.of(type).getPackage(), JavaModule.ofType(ForStaticField.class))) {
                    ForStaticField.doPrivileged(new SetAccessibleAction<Field>(field), this.accessControlContext);
                }
                field.set(null, this.value);
            }
            catch (IllegalAccessException exception) {
                throw new IllegalArgumentException("Cannot access " + this.fieldName + " from " + type, exception);
            }
            catch (NoSuchFieldException exception) {
                throw new IllegalStateException("There is no field " + this.fieldName + " defined on " + type, exception);
            }
        }

        @Override
        public boolean isAlive() {
            return true;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum NoOp implements LoadedTypeInitializer
    {
        INSTANCE;


        @Override
        public void onLoad(Class<?> type) {
        }

        @Override
        public boolean isAlive() {
            return false;
        }
    }
}

