/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.type.RecordComponentDescription;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.dynamic.Transformer;
import me.lucko.luckperms.lib.bytebuddy.dynamic.scaffold.TypeWriter;
import me.lucko.luckperms.lib.bytebuddy.implementation.attribute.RecordComponentAttributeAppender;
import me.lucko.luckperms.lib.bytebuddy.matcher.ElementMatcher;
import me.lucko.luckperms.lib.bytebuddy.matcher.LatentMatcher;
import me.lucko.luckperms.lib.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface RecordComponentRegistry {
    public RecordComponentRegistry prepend(LatentMatcher<? super RecordComponentDescription> var1, RecordComponentAttributeAppender.Factory var2, Transformer<RecordComponentDescription> var3);

    public Compiled compile(TypeDescription var1);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Default
    implements RecordComponentRegistry {
        private final List<Entry> entries;

        public Default() {
            this(Collections.emptyList());
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public RecordComponentRegistry prepend(LatentMatcher<? super RecordComponentDescription> matcher, RecordComponentAttributeAppender.Factory recordComponentAttributeAppenderFactory, Transformer<RecordComponentDescription> transformer) {
            ArrayList<Entry> entries = new ArrayList<Entry>(this.entries.size() + 1);
            entries.add(new Entry(matcher, recordComponentAttributeAppenderFactory, transformer));
            entries.addAll(this.entries);
            return new Default(entries);
        }

        @Override
        public me.lucko.luckperms.lib.bytebuddy.dynamic.scaffold.RecordComponentRegistry$Compiled compile(TypeDescription instrumentedType) {
            ArrayList<Compiled.Entry> entries = new ArrayList<Compiled.Entry>(this.entries.size());
            HashMap<RecordComponentAttributeAppender.Factory, RecordComponentAttributeAppender> recordComponentAttributeAppenders = new HashMap<RecordComponentAttributeAppender.Factory, RecordComponentAttributeAppender>();
            for (Entry entry : this.entries) {
                RecordComponentAttributeAppender recordComponentAttributeAppender = (RecordComponentAttributeAppender)recordComponentAttributeAppenders.get(entry.getRecordComponentAttributeAppender());
                if (recordComponentAttributeAppender == null) {
                    recordComponentAttributeAppender = entry.getRecordComponentAttributeAppender().make(instrumentedType);
                    recordComponentAttributeAppenders.put(entry.getRecordComponentAttributeAppender(), recordComponentAttributeAppender);
                }
                entries.add(new Compiled.Entry(entry.resolve(instrumentedType), recordComponentAttributeAppender, entry.getTransformer()));
            }
            return new Compiled(instrumentedType, entries);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class Compiled
        implements me.lucko.luckperms.lib.bytebuddy.dynamic.scaffold.RecordComponentRegistry$Compiled {
            private final TypeDescription instrumentedType;
            private final List<Entry> entries;

            protected Compiled(TypeDescription instrumentedType, List<Entry> entries) {
                this.instrumentedType = instrumentedType;
                this.entries = entries;
            }

            @Override
            public TypeWriter.RecordComponentPool.Record target(RecordComponentDescription recordComponentDescription) {
                for (Entry entry : this.entries) {
                    if (!entry.matches(recordComponentDescription)) continue;
                    return entry.bind(this.instrumentedType, recordComponentDescription);
                }
                return new TypeWriter.RecordComponentPool.Record.ForImplicitRecordComponent(recordComponentDescription);
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class Entry
            implements ElementMatcher<RecordComponentDescription> {
                private final ElementMatcher<? super RecordComponentDescription> matcher;
                private final RecordComponentAttributeAppender recordComponentAttributeAppender;
                private final Transformer<RecordComponentDescription> transformer;

                protected Entry(ElementMatcher<? super RecordComponentDescription> matcher, RecordComponentAttributeAppender recordComponentAttributeAppender, Transformer<RecordComponentDescription> transformer) {
                    this.matcher = matcher;
                    this.recordComponentAttributeAppender = recordComponentAttributeAppender;
                    this.transformer = transformer;
                }

                protected TypeWriter.RecordComponentPool.Record bind(TypeDescription instrumentedType, RecordComponentDescription recordComponentDescription) {
                    return new TypeWriter.RecordComponentPool.Record.ForExplicitRecordComponent(this.recordComponentAttributeAppender, this.transformer.transform(instrumentedType, recordComponentDescription));
                }

                @Override
                public boolean matches(@MaybeNull RecordComponentDescription target) {
                    return this.matcher.matches(target);
                }
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class Entry
        implements LatentMatcher<RecordComponentDescription> {
            private final LatentMatcher<? super RecordComponentDescription> matcher;
            private final RecordComponentAttributeAppender.Factory recordComponentAttributeAppender;
            private final Transformer<RecordComponentDescription> transformer;

            protected Entry(LatentMatcher<? super RecordComponentDescription> matcher, RecordComponentAttributeAppender.Factory recordComponentAttributeAppender, Transformer<RecordComponentDescription> transformer) {
                this.matcher = matcher;
                this.recordComponentAttributeAppender = recordComponentAttributeAppender;
                this.transformer = transformer;
            }

            protected RecordComponentAttributeAppender.Factory getRecordComponentAttributeAppender() {
                return this.recordComponentAttributeAppender;
            }

            protected Transformer<RecordComponentDescription> getTransformer() {
                return this.transformer;
            }

            @Override
            public ElementMatcher<? super RecordComponentDescription> resolve(TypeDescription typeDescription) {
                return this.matcher.resolve(typeDescription);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Compiled
    extends TypeWriter.RecordComponentPool {

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static enum NoOp implements Compiled
        {
            INSTANCE;


            @Override
            public TypeWriter.RecordComponentPool.Record target(RecordComponentDescription recordComponentDescription) {
                return new TypeWriter.RecordComponentPool.Record.ForImplicitRecordComponent(recordComponentDescription);
            }
        }
    }
}

