/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.field.FieldDescription;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.dynamic.Transformer;
import me.lucko.luckperms.lib.bytebuddy.dynamic.scaffold.TypeWriter;
import me.lucko.luckperms.lib.bytebuddy.implementation.attribute.FieldAttributeAppender;
import me.lucko.luckperms.lib.bytebuddy.matcher.ElementMatcher;
import me.lucko.luckperms.lib.bytebuddy.matcher.LatentMatcher;
import me.lucko.luckperms.lib.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface FieldRegistry {
    public FieldRegistry prepend(LatentMatcher<? super FieldDescription> var1, FieldAttributeAppender.Factory var2, @MaybeNull Object var3, Transformer<FieldDescription> var4);

    public Compiled compile(TypeDescription var1);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Default
    implements FieldRegistry {
        private final List<Entry> entries;

        public Default() {
            this(Collections.emptyList());
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public FieldRegistry prepend(LatentMatcher<? super FieldDescription> matcher, FieldAttributeAppender.Factory fieldAttributeAppenderFactory, @MaybeNull Object defaultValue, Transformer<FieldDescription> transformer) {
            ArrayList<Entry> entries = new ArrayList<Entry>(this.entries.size() + 1);
            entries.add(new Entry(matcher, fieldAttributeAppenderFactory, defaultValue, transformer));
            entries.addAll(this.entries);
            return new Default(entries);
        }

        @Override
        public me.lucko.luckperms.lib.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled compile(TypeDescription instrumentedType) {
            ArrayList<Compiled.Entry> entries = new ArrayList<Compiled.Entry>(this.entries.size());
            HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender> fieldAttributeAppenders = new HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender>();
            for (Entry entry : this.entries) {
                FieldAttributeAppender fieldAttributeAppender = (FieldAttributeAppender)fieldAttributeAppenders.get(entry.getFieldAttributeAppenderFactory());
                if (fieldAttributeAppender == null) {
                    fieldAttributeAppender = entry.getFieldAttributeAppenderFactory().make(instrumentedType);
                    fieldAttributeAppenders.put(entry.getFieldAttributeAppenderFactory(), fieldAttributeAppender);
                }
                entries.add(new Compiled.Entry(entry.resolve(instrumentedType), fieldAttributeAppender, entry.getDefaultValue(), entry.getTransformer()));
            }
            return new Compiled(instrumentedType, entries);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class Compiled
        implements me.lucko.luckperms.lib.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled {
            private final TypeDescription instrumentedType;
            private final List<Entry> entries;

            protected Compiled(TypeDescription instrumentedType, List<Entry> entries) {
                this.instrumentedType = instrumentedType;
                this.entries = entries;
            }

            @Override
            public TypeWriter.FieldPool.Record target(FieldDescription fieldDescription) {
                for (Entry entry : this.entries) {
                    if (!entry.matches(fieldDescription)) continue;
                    return entry.bind(this.instrumentedType, fieldDescription);
                }
                return new TypeWriter.FieldPool.Record.ForImplicitField(fieldDescription);
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            @HashCodeAndEqualsPlugin.Enhance
            protected static class Entry
            implements ElementMatcher<FieldDescription> {
                private final ElementMatcher<? super FieldDescription> matcher;
                private final FieldAttributeAppender fieldAttributeAppender;
                @MaybeNull
                @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
                private final Object defaultValue;
                private final Transformer<FieldDescription> transformer;

                protected Entry(ElementMatcher<? super FieldDescription> matcher, FieldAttributeAppender fieldAttributeAppender, @MaybeNull Object defaultValue, Transformer<FieldDescription> transformer) {
                    this.matcher = matcher;
                    this.fieldAttributeAppender = fieldAttributeAppender;
                    this.defaultValue = defaultValue;
                    this.transformer = transformer;
                }

                protected TypeWriter.FieldPool.Record bind(TypeDescription instrumentedType, FieldDescription fieldDescription) {
                    return new TypeWriter.FieldPool.Record.ForExplicitField(this.fieldAttributeAppender, this.defaultValue, this.transformer.transform(instrumentedType, fieldDescription));
                }

                @Override
                public boolean matches(@MaybeNull FieldDescription target) {
                    return this.matcher.matches(target);
                }
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class Entry
        implements LatentMatcher<FieldDescription> {
            private final LatentMatcher<? super FieldDescription> matcher;
            private final FieldAttributeAppender.Factory fieldAttributeAppenderFactory;
            @MaybeNull
            @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
            private final Object defaultValue;
            private final Transformer<FieldDescription> transformer;

            protected Entry(LatentMatcher<? super FieldDescription> matcher, FieldAttributeAppender.Factory fieldAttributeAppenderFactory, @MaybeNull Object defaultValue, Transformer<FieldDescription> transformer) {
                this.matcher = matcher;
                this.fieldAttributeAppenderFactory = fieldAttributeAppenderFactory;
                this.defaultValue = defaultValue;
                this.transformer = transformer;
            }

            protected FieldAttributeAppender.Factory getFieldAttributeAppenderFactory() {
                return this.fieldAttributeAppenderFactory;
            }

            @MaybeNull
            protected Object getDefaultValue() {
                return this.defaultValue;
            }

            protected Transformer<FieldDescription> getTransformer() {
                return this.transformer;
            }

            @Override
            public ElementMatcher<? super FieldDescription> resolve(TypeDescription typeDescription) {
                return this.matcher.resolve(typeDescription);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Compiled
    extends TypeWriter.FieldPool {

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static enum NoOp implements Compiled
        {
            INSTANCE;


            @Override
            public TypeWriter.FieldPool.Record target(FieldDescription fieldDescription) {
                return new TypeWriter.FieldPool.Record.ForImplicitField(fieldDescription);
            }
        }
    }
}

