/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import me.lucko.luckperms.lib.bytebuddy.build.HashCodeAndEqualsPlugin;
import me.lucko.luckperms.lib.bytebuddy.description.type.TypeDescription;
import me.lucko.luckperms.lib.bytebuddy.dynamic.DynamicType;
import me.lucko.luckperms.lib.bytebuddy.dynamic.NexusAccessor;
import me.lucko.luckperms.lib.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import me.lucko.luckperms.lib.bytebuddy.dynamic.scaffold.TypeInitializer;
import me.lucko.luckperms.lib.bytebuddy.implementation.LoadedTypeInitializer;
import me.lucko.luckperms.lib.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface TypeResolutionStrategy {
    public Resolved resolve();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Disabled implements TypeResolutionStrategy,
    Resolved
    {
        INSTANCE;


        @Override
        public Resolved resolve() {
            return this;
        }

        @Override
        public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
            return typeInitializer;
        }

        @Override
        public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, @MaybeNull S classLoader, ClassLoadingStrategy<? super S> classLoadingStrategy) {
            throw new IllegalStateException("Cannot initialize a dynamic type for a disabled type resolution strategy");
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Lazy implements TypeResolutionStrategy,
    Resolved
    {
        INSTANCE;


        @Override
        public Resolved resolve() {
            return this;
        }

        @Override
        public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
            return typeInitializer;
        }

        @Override
        public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, @MaybeNull S classLoader, ClassLoadingStrategy<? super S> classLoadingStrategy) {
            return classLoadingStrategy.load(classLoader, dynamicType.getAllTypes());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class Active
    implements TypeResolutionStrategy {
        private final NexusAccessor nexusAccessor;

        public Active() {
            this(new NexusAccessor());
        }

        public Active(NexusAccessor nexusAccessor) {
            this.nexusAccessor = nexusAccessor;
        }

        @Override
        @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="Avoids thread-contention.")
        public me.lucko.luckperms.lib.bytebuddy.dynamic.TypeResolutionStrategy$Resolved resolve() {
            return new Resolved(this.nexusAccessor, new Random().nextInt());
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @HashCodeAndEqualsPlugin.Enhance
        protected static class Resolved
        implements me.lucko.luckperms.lib.bytebuddy.dynamic.TypeResolutionStrategy$Resolved {
            private final NexusAccessor nexusAccessor;
            private final int identification;

            protected Resolved(NexusAccessor nexusAccessor, int identification) {
                this.nexusAccessor = nexusAccessor;
                this.identification = identification;
            }

            @Override
            public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
                return typeInitializer.expandWith(new NexusAccessor.InitializationAppender(this.identification));
            }

            @Override
            public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, @MaybeNull S classLoader, ClassLoadingStrategy<? super S> classLoadingStrategy) {
                HashMap<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = new HashMap<TypeDescription, LoadedTypeInitializer>(dynamicType.getLoadedTypeInitializers());
                TypeDescription instrumentedType = dynamicType.getTypeDescription();
                Map<TypeDescription, Class<?>> types = classLoadingStrategy.load(classLoader, dynamicType.getAllTypes());
                this.nexusAccessor.register(instrumentedType.getName(), types.get(instrumentedType).getClassLoader(), this.identification, (LoadedTypeInitializer)loadedTypeInitializers.remove(instrumentedType));
                for (Map.Entry entry : loadedTypeInitializers.entrySet()) {
                    ((LoadedTypeInitializer)entry.getValue()).onLoad(types.get(entry.getKey()));
                }
                return types;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Passive implements TypeResolutionStrategy,
    Resolved
    {
        INSTANCE;


        @Override
        public Resolved resolve() {
            return this;
        }

        @Override
        public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
            return typeInitializer;
        }

        @Override
        public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, @MaybeNull S classLoader, ClassLoadingStrategy<? super S> classLoadingStrategy) {
            Map<TypeDescription, Class<?>> types = classLoadingStrategy.load(classLoader, dynamicType.getAllTypes());
            for (Map.Entry<TypeDescription, LoadedTypeInitializer> entry : dynamicType.getLoadedTypeInitializers().entrySet()) {
                entry.getValue().onLoad(types.get(entry.getKey()));
            }
            return new HashMap(types);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Resolved {
        public TypeInitializer injectedInto(TypeInitializer var1);

        public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType var1, @MaybeNull S var2, ClassLoadingStrategy<? super S> var3);
    }
}

