/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.player.audience;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.util.PlayerType;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.player.audience.InvalidPlayerIdentifierException;
import org.geysermc.floodgate.player.audience.ProfileAudience;
import org.geysermc.floodgate.shadow.org.incendo.cloud.component.CommandComponent;
import org.geysermc.floodgate.shadow.org.incendo.cloud.parser.ArgumentParseResult;
import org.geysermc.floodgate.shadow.org.incendo.cloud.parser.standard.StringParser;
import org.geysermc.floodgate.shadow.org.incendo.cloud.suggestion.Suggestion;
import org.geysermc.floodgate.util.BrigadierUtils;

public class PlayerAudienceArgument {
    public static CommandComponent.Builder<UserAudience, ProfileAudience> ofAnyIdentifierBedrock(String name) {
        return PlayerAudienceArgument.of(name, true, true, PlayerType.ONLY_BEDROCK);
    }

    public static CommandComponent.Builder<UserAudience, ProfileAudience> ofAnyUsernameBoth(String name) {
        return PlayerAudienceArgument.of(name, false, true, PlayerType.ALL_PLAYERS);
    }

    private static CommandComponent.Builder<UserAudience, ProfileAudience> of(String name, boolean allowUuid, boolean allowOffline, PlayerType limitTo) {
        return CommandComponent.builder().name(name).parser(StringParser.quotedStringParser().flatMapSuccess(ProfileAudience.class, (context, input) -> {
            ProfileAudience profileAudience;
            CommandUtil commandUtil = (CommandUtil)context.get("CommandUtil");
            if (input.length() > 16) {
                if (!allowUuid) {
                    return ArgumentParseResult.failureFuture(new InvalidPlayerIdentifierException("UUID is not allowed here"));
                }
                if (input.length() != 32 && input.length() != 36) {
                    return ArgumentParseResult.failureFuture(new InvalidPlayerIdentifierException("Expected player name/UUID"));
                }
                try {
                    Object player = commandUtil.getPlayerByUuid(UUID.fromString(input), limitTo);
                    profileAudience = commandUtil.getProfileAudience(player, allowOffline);
                }
                catch (IllegalArgumentException ignored) {
                    return ArgumentParseResult.failureFuture(new InvalidPlayerIdentifierException("Invalid UUID '" + input + "'"));
                }
            } else {
                Object player = commandUtil.getPlayerByUsername((String)input, limitTo);
                profileAudience = commandUtil.getProfileAudience(player, allowOffline);
            }
            if (profileAudience == null) {
                return ArgumentParseResult.failureFuture(new InvalidPlayerIdentifierException("Invalid player '" + input + "'"));
            }
            return ArgumentParseResult.successFuture(profileAudience);
        })).suggestionProvider((context, input) -> {
            CommandUtil commandUtil = (CommandUtil)context.get("CommandUtil");
            boolean quoted = input.remainingInput().startsWith("\"");
            ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
            for (String player : commandUtil.getOnlineUsernames(limitTo)) {
                suggestions.add(Suggestion.suggestion(BrigadierUtils.escapeIfRequired(player, quoted)));
            }
            return CompletableFuture.completedFuture(suggestions);
        });
    }
}

