/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.listener;

import java.util.UUID;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.MojangUtils;

public final class SpigotListener
implements Listener {
    @Inject
    private SimpleFloodgateApi api;
    @Inject
    private LanguageManager languageManager;
    @Inject
    private FloodgateLogger logger;
    @Inject
    private MojangUtils mojangUtils;
    @Inject
    private SkinApplier skinApplier;

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        UUID uniqueId = event.getPlayer().getUniqueId();
        FloodgatePlayer player = this.api.getPlayer(uniqueId);
        if (player != null) {
            this.logger.translatedInfo("floodgate.ingame.login_name", player.getCorrectUsername(), player.getCorrectUniqueId());
            this.languageManager.loadLocale(player.getLanguageCode());
            if (player.isLinked()) {
                this.mojangUtils.skinFor(player.getCorrectUniqueId()).whenComplete((skin, exception) -> {
                    if (exception != null) {
                        this.logger.debug("Unexpected skin fetch error for " + player.getCorrectUniqueId(), exception);
                        return;
                    }
                    this.skinApplier.applySkin(player, (SkinApplyEvent.SkinData)skin, true);
                });
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.api.playerRemoved(event.getPlayer().getUniqueId());
    }
}

