/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.command.main;

import java.util.Locale;
import org.geysermc.floodgate.command.main.FirewallCheckSubcommand;
import org.geysermc.floodgate.command.main.VersionSubcommand;
import org.geysermc.floodgate.command.util.Permission;
import org.geysermc.floodgate.platform.command.FloodgateCommand;
import org.geysermc.floodgate.platform.command.FloodgateSubCommand;
import org.geysermc.floodgate.platform.command.SubCommands;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.shadow.org.incendo.cloud.Command;
import org.geysermc.floodgate.shadow.org.incendo.cloud.CommandManager;
import org.geysermc.floodgate.shadow.org.incendo.cloud.context.CommandContext;
import org.geysermc.floodgate.shadow.org.incendo.cloud.description.Description;

public final class MainCommand
extends SubCommands
implements FloodgateCommand {
    public MainCommand() {
        this.defineSubCommand(FirewallCheckSubcommand.class);
        this.defineSubCommand(VersionSubcommand.class);
    }

    public Command<UserAudience> buildCommand(CommandManager<UserAudience> commandManager) {
        Command.Builder<UserAudience> builder = commandManager.commandBuilder("floodgate", Description.of("A set of Floodgate related actions in one command"), new String[0]).senderType(UserAudience.class).permission(Permission.COMMAND_MAIN.get()).handler(this::execute);
        for (FloodgateSubCommand subCommand : this.subCommands()) {
            commandManager.command(builder.literal(subCommand.name().toLowerCase(Locale.ROOT), Description.of(subCommand.description()), new String[0]).permission(subCommand.permission().get()).handler(subCommand::execute));
        }
        return builder.build();
    }

    public void execute(CommandContext<UserAudience> context) {
        StringBuilder helpMessage = new StringBuilder("Available subcommands are:\n");
        for (FloodgateSubCommand subCommand : this.subCommands()) {
            if (!context.sender().hasPermission(subCommand.permission().get())) continue;
            helpMessage.append('\n').append('\u00a7').append('b').append(subCommand.name().toLowerCase(Locale.ROOT)).append('\u00a7').append("f - ").append('\u00a7').append('7').append(subCommand.description());
        }
        context.sender().sendMessage(helpMessage.toString());
    }
}

