/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import org.geysermc.floodgate.addon.data.SpigotDataHandler;
import org.geysermc.floodgate.api.SimpleFloodgateApi;
import org.geysermc.floodgate.api.inject.InjectorAddon;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.name.Named;
import org.geysermc.floodgate.util.SpigotVersionSpecificMethods;

public final class SpigotDataAddon
implements InjectorAddon {
    @Inject
    private FloodgateHandshakeHandler handshakeHandler;
    @Inject
    private FloodgateConfig config;
    @Inject
    private SimpleFloodgateApi api;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="packetHandler")
    private String packetHandlerName;
    @Inject
    @Named(value="kickMessageAttribute")
    private AttributeKey<String> kickMessageAttribute;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;
    @Inject
    private SpigotVersionSpecificMethods versionSpecificMethods;

    @Override
    public void onInject(Channel channel, boolean toServer) {
        channel.pipeline().addBefore(this.packetHandlerName, "floodgate_data_handler", (ChannelHandler)new SpigotDataHandler(this.handshakeHandler, this.config, this.kickMessageAttribute, this.versionSpecificMethods));
    }

    @Override
    public void onChannelClosed(Channel channel) {
        FloodgatePlayer player = (FloodgatePlayer)channel.attr(this.playerAttribute).get();
        if (player != null && this.api.setPendingRemove(player)) {
            this.logger.translatedInfo("floodgate.ingame.disconnect_name", player.getCorrectUsername());
        }
    }

    @Override
    public void onRemoveInject(Channel channel) {
    }

    @Override
    public boolean shouldInject() {
        return true;
    }
}

