/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Queue;
import org.geysermc.floodgate.shadow.com.google.common.collect.Queues;

public class PacketBlocker
extends ChannelInboundHandlerAdapter {
    private final Queue<Object> packetQueue = Queues.newConcurrentLinkedQueue();
    private volatile boolean blockPackets;
    private ChannelHandlerContext ctx;

    public void enable() {
        this.blockPackets = true;
    }

    public void disable() {
        Object packet;
        this.blockPackets = false;
        while ((packet = this.packetQueue.poll()) != null) {
            this.ctx.fireChannelRead(packet);
        }
        this.ctx.pipeline().remove((ChannelHandler)this);
    }

    public boolean enabled() {
        return this.blockPackets;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.blockPackets || !this.packetQueue.isEmpty()) {
            this.packetQueue.add(msg);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }
}

