/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.data;

import io.netty.channel.Channel;
import java.util.UUID;
import org.geysermc.floodgate.api.handshake.HandshakeData;
import org.geysermc.floodgate.config.FloodgateConfig;
import org.geysermc.floodgate.util.BedrockData;
import org.geysermc.floodgate.util.LinkedPlayer;
import org.geysermc.floodgate.util.Utils;

public class HandshakeDataImpl
implements HandshakeData {
    private final Channel channel;
    private final boolean floodgatePlayer;
    private final BedrockData bedrockData;
    private final String javaUsername;
    private final UUID javaUniqueId;
    private LinkedPlayer linkedPlayer;
    private String hostname;
    private String ip;
    private String disconnectReason;

    public HandshakeDataImpl(Channel channel, boolean floodgatePlayer, BedrockData bedrockData, FloodgateConfig config, LinkedPlayer linkedPlayer, String hostname) {
        this.channel = channel;
        this.floodgatePlayer = floodgatePlayer;
        this.bedrockData = bedrockData;
        this.linkedPlayer = linkedPlayer;
        this.hostname = hostname;
        String javaUsername = null;
        UUID javaUniqueId = null;
        if (bedrockData != null) {
            String prefix = config.getUsernamePrefix();
            int usernameLength = Math.min(bedrockData.getUsername().length(), 16 - prefix.length());
            javaUsername = prefix + bedrockData.getUsername().substring(0, usernameLength);
            if (config.isReplaceSpaces()) {
                javaUsername = javaUsername.replace(" ", "_");
            }
            javaUniqueId = Utils.getJavaUuid(bedrockData.getXuid());
            this.ip = bedrockData.getIp();
        }
        this.javaUsername = javaUsername;
        this.javaUniqueId = javaUniqueId;
    }

    @Override
    public String getCorrectUsername() {
        return this.linkedPlayer != null ? this.linkedPlayer.getJavaUsername() : this.javaUsername;
    }

    @Override
    public UUID getCorrectUniqueId() {
        return this.linkedPlayer != null ? this.linkedPlayer.getJavaUniqueId() : this.javaUniqueId;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public boolean isFloodgatePlayer() {
        return this.floodgatePlayer;
    }

    @Override
    public BedrockData getBedrockData() {
        return this.bedrockData;
    }

    @Override
    public String getJavaUsername() {
        return this.javaUsername;
    }

    @Override
    public UUID getJavaUniqueId() {
        return this.javaUniqueId;
    }

    @Override
    public LinkedPlayer getLinkedPlayer() {
        return this.linkedPlayer;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public String getDisconnectReason() {
        return this.disconnectReason;
    }

    @Override
    public void setLinkedPlayer(LinkedPlayer linkedPlayer) {
        this.linkedPlayer = linkedPlayer;
    }

    @Override
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Override
    public void setDisconnectReason(String disconnectReason) {
        this.disconnectReason = disconnectReason;
    }
}

