/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.loader.callback;

import java.util.Objects;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CallbackResult {
    private final IllegalStateException error;

    private CallbackResult(IllegalStateException error) {
        this.error = error;
    }

    public static @NonNull CallbackResult ok() {
        return new CallbackResult(null);
    }

    public static @NonNull CallbackResult failed(@NonNull String errorMessage) {
        Objects.requireNonNull(errorMessage);
        return new CallbackResult(new IllegalStateException(errorMessage));
    }

    public @Nullable IllegalStateException error() {
        return this.error;
    }

    public boolean success() {
        return this.error == null;
    }

    public CallbackResult ifSucceeded(Callable<CallbackResult> onSucceeded) {
        try {
            CallbackResult result = onSucceeded.call();
            return result != null ? result : this;
        }
        catch (Exception exception) {
            return CallbackResult.failed(String.format("An unknown error happened while executing ifSucceeded: %s", exception.getMessage()));
        }
    }
}

