/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.authentication;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.authentication.core.Token;
import redis.clients.authentication.core.TokenAuthConfig;
import redis.clients.authentication.core.TokenListener;
import redis.clients.authentication.core.TokenManager;
import redis.clients.jedis.Connection;
import redis.clients.jedis.RedisCredentials;
import redis.clients.jedis.authentication.AuthXEventListener;
import redis.clients.jedis.authentication.JedisAuthenticationException;
import redis.clients.jedis.authentication.TokenCredentials;

public final class AuthXManager
implements Supplier<RedisCredentials> {
    private static final Logger log = LoggerFactory.getLogger(AuthXManager.class);
    private TokenManager tokenManager;
    private List<WeakReference<Connection>> connections = Collections.synchronizedList(new ArrayList());
    private Token currentToken;
    private AuthXEventListener listener = AuthXEventListener.NOOP_LISTENER;
    private List<Consumer<Token>> postAuthenticateHooks = new ArrayList<Consumer<Token>>();
    private AtomicReference<CompletableFuture<Void>> uniqueStarterTask = new AtomicReference();

    protected AuthXManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public AuthXManager(TokenAuthConfig tokenAuthConfig) {
        this(new TokenManager(tokenAuthConfig.getIdentityProviderConfig().getProvider(), tokenAuthConfig.getTokenManagerConfig()));
    }

    public void start() {
        Future<Void> safeStarter = this.safeStart(this::tokenManagerStart);
        try {
            safeStarter.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("AuthXManager failed to start!", e);
            throw new JedisAuthenticationException("AuthXManager failed to start!", e instanceof ExecutionException ? e.getCause() : e);
        }
    }

    private Future<Void> safeStart(Runnable starter) {
        if (this.uniqueStarterTask.compareAndSet(null, new CompletableFuture())) {
            try {
                starter.run();
                this.uniqueStarterTask.get().complete(null);
            }
            catch (Exception e) {
                this.uniqueStarterTask.get().completeExceptionally(e);
            }
        }
        return this.uniqueStarterTask.get();
    }

    private void tokenManagerStart() {
        this.tokenManager.start(new TokenListener(){

            @Override
            public void onTokenRenewed(Token token) {
                AuthXManager.this.currentToken = token;
                AuthXManager.this.authenticateConnections(token);
            }

            @Override
            public void onError(Exception reason) {
                AuthXManager.this.listener.onIdentityProviderError(reason);
            }
        }, true);
    }

    public void authenticateConnections(Token token) {
        TokenCredentials credentialsFromToken = new TokenCredentials(token);
        for (WeakReference<Connection> connectionRef : this.connections) {
            Connection connection = (Connection)connectionRef.get();
            if (connection != null) {
                connection.setCredentials(credentialsFromToken);
                continue;
            }
            this.connections.remove(connectionRef);
        }
        this.postAuthenticateHooks.forEach(hook -> hook.accept(token));
    }

    public Connection addConnection(Connection connection) {
        this.connections.add(new WeakReference<Connection>(connection));
        return connection;
    }

    public void stop() {
        this.tokenManager.stop();
    }

    public void setListener(AuthXEventListener listener) {
        if (listener != null) {
            this.listener = listener;
        }
    }

    public void addPostAuthenticationHook(Consumer<Token> postAuthenticateHook) {
        this.postAuthenticateHooks.add(postAuthenticateHook);
    }

    public void removePostAuthenticationHook(Consumer<Token> postAuthenticateHook) {
        this.postAuthenticateHooks.remove(postAuthenticateHook);
    }

    public AuthXEventListener getListener() {
        return this.listener;
    }

    @Override
    public RedisCredentials get() {
        return new TokenCredentials(this.currentToken);
    }
}

