/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.function.Supplier;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.authentication.AuthXEventListener;
import redis.clients.jedis.authentication.AuthXManager;
import redis.clients.jedis.authentication.JedisAuthenticationException;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.csc.CacheConnection;
import redis.clients.jedis.exceptions.JedisException;

public class ConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final JedisClientConfig clientConfig;
    private Supplier<Connection> objectMaker;
    private Connection.Builder connectionBuilder;
    private AuthXEventListener authXEventListener;

    public static Builder builder() {
        return new Builder();
    }

    public ConnectionFactory(HostAndPort hostAndPort) {
        this(ConnectionFactory.builder().hostAndPort(hostAndPort).withDefaults());
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(ConnectionFactory.builder().hostAndPort(hostAndPort).clientConfig(clientConfig).withDefaults());
    }

    @Experimental
    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache csCache) {
        this(ConnectionFactory.builder().hostAndPort(hostAndPort).clientConfig(clientConfig).cache(csCache).withDefaults());
    }

    public ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this(ConnectionFactory.builder().socketFactory(jedisSocketFactory).clientConfig(clientConfig).withDefaults());
    }

    public ConnectionFactory(Builder builder) {
        this.clientConfig = builder.getClientConfig();
        this.connectionBuilder = builder.getConnectionBuilder();
        this.initAuthXManager();
    }

    private void initAuthXManager() {
        AuthXManager authXManager = this.clientConfig.getAuthXManager();
        if (authXManager == null) {
            this.objectMaker = () -> this.build();
            this.authXEventListener = AuthXEventListener.NOOP_LISTENER;
        } else {
            this.objectMaker = () -> authXManager.addConnection(this.build());
            this.authXEventListener = authXManager.getListener();
            authXManager.start();
        }
    }

    private Connection build() {
        return this.connectionBuilder.build();
    }

    @Override
    public void activateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    @Override
    public void destroyObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = pooledConnection.getObject();
        if (jedis.isConnected()) {
            try {
                jedis.close();
            }
            catch (RuntimeException e) {
                logger.debug("Error while close", e);
            }
        }
    }

    @Override
    public PooledObject<Connection> makeObject() throws Exception {
        try {
            Connection jedis = this.objectMaker.get();
            return new DefaultPooledObject<Connection>(jedis);
        }
        catch (JedisException je) {
            logger.debug("Error while makeObject", je);
            throw je;
        }
    }

    @Override
    public void passivateObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = pooledConnection.getObject();
        this.reAuthenticate(jedis);
    }

    @Override
    public boolean validateObject(PooledObject<Connection> pooledConnection) {
        Connection jedis = pooledConnection.getObject();
        try {
            if (!jedis.isConnected()) {
                return false;
            }
            this.reAuthenticate(jedis);
            return jedis.ping();
        }
        catch (Exception e) {
            logger.warn("Error while validating pooled Connection object.", e);
            return false;
        }
    }

    private void reAuthenticate(Connection jedis) throws Exception {
        try {
            String result = jedis.reAuthenticate();
            if (result != null && !result.equals("OK")) {
                String msg = "Re-authentication failed with server response: " + result;
                JedisAuthenticationException failedAuth = new JedisAuthenticationException(msg);
                logger.error(failedAuth.getMessage(), failedAuth);
                this.authXEventListener.onConnectionAuthenticationError(failedAuth);
                return;
            }
        }
        catch (Exception e) {
            logger.error("Error while re-authenticating connection", e);
            this.authXEventListener.onConnectionAuthenticationError(e);
            throw e;
        }
    }

    public static class Builder {
        private JedisClientConfig clientConfig;
        private Connection.Builder connectionBuilder;
        private JedisSocketFactory jedisSocketFactory;
        private Cache cache;
        private HostAndPort hostAndPort;

        public Builder clientConfig(JedisClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public Builder connectionBuilder(Connection.Builder connectionBuilder) {
            this.connectionBuilder = connectionBuilder;
            return this;
        }

        public Builder socketFactory(JedisSocketFactory jedisSocketFactory) {
            this.jedisSocketFactory = jedisSocketFactory;
            return this;
        }

        public Builder cache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Builder hostAndPort(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
            return this;
        }

        public Connection.Builder getConnectionBuilder() {
            return this.connectionBuilder;
        }

        public JedisSocketFactory getJedisSocketFactory() {
            return this.jedisSocketFactory;
        }

        public JedisClientConfig getClientConfig() {
            return this.clientConfig;
        }

        public Cache getCache() {
            return this.cache;
        }

        public ConnectionFactory build() {
            this.withDefaults();
            return new ConnectionFactory(this);
        }

        private Builder withDefaults() {
            if (this.jedisSocketFactory == null) {
                this.jedisSocketFactory = this.createDefaultSocketFactory();
            }
            if (this.connectionBuilder == null) {
                this.connectionBuilder = this.createDefaultConnectionBuilder();
            }
            return this;
        }

        private JedisSocketFactory createDefaultSocketFactory() {
            if (this.clientConfig == null) {
                this.clientConfig = DefaultJedisClientConfig.builder().build();
            }
            if (this.hostAndPort == null) {
                throw new IllegalStateException("HostAndPort is required when no socketFactory is provided");
            }
            return new DefaultJedisSocketFactory(this.hostAndPort, this.clientConfig);
        }

        private Connection.Builder createDefaultConnectionBuilder() {
            Connection.Builder connBuilder = this.cache == null ? Connection.builder() : CacheConnection.builder(this.cache);
            connBuilder.socketFactory(this.jedisSocketFactory).clientConfig(this.clientConfig);
            return connBuilder;
        }
    }
}

