/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.votereminding;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class VoteReminding {
    private VotingPluginMain plugin;
    private ScheduledExecutorService timer;
    private ConcurrentHashMap<UUID, Boolean> remindersEnabled = new ConcurrentHashMap();

    public VoteReminding(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public void checkRemind(VotingPluginUser user) {
        if ((user.hasPermission("VotingPlugin.Login.RemindVotes") || user.hasPermission("VotingPlugin.Player")) && this.shouldRemind(user)) {
            if (!this.plugin.getConfigFile().isVoteRemindingRemindOnlyOnce()) {
                this.runRemind(user);
            } else if (!user.isReminded()) {
                this.runRemind(user);
            }
        }
    }

    private void giveReward(VotingPluginUser user) {
        new RewardBuilder((ConfigurationSection)this.plugin.getConfigFile().getData(), this.plugin.getConfigFile().getVoteRemindingRewardsPath()).withPlaceHolder("sitesavailable", "" + user.getSitesNotVotedOn()).setGiveOffline(false).disableDefaultWorlds().send((AdvancedCoreUser)user);
    }

    public void loadRemindChecking() {
        if (this.timer != null) {
            this.timer.shutdownNow();
        }
        if (this.plugin.getConfigFile().getVoteRemindingRemindDelay() > 0) {
            this.timer = Executors.newScheduledThreadPool(1);
            this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (VoteReminding.this.plugin != null && VoteReminding.this.plugin.isEnabled()) {
                        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                            VotingPluginUser user = VoteReminding.this.plugin.getVotingPluginUserManager().getVotingPluginUser(player);
                            if (VoteReminding.this.plugin.getOptions().isTreatVanishAsOffline() && user.isVanished()) continue;
                            VoteReminding.this.checkRemind(user);
                        }
                    } else {
                        VoteReminding.this.timer.shutdown();
                    }
                }
            }, 30L, this.plugin.getConfigFile().getVoteRemindingRemindDelay() * 60, TimeUnit.SECONDS);
        }
    }

    public void loadReminds() {
        List<String> uuidsStr = this.plugin.getServerData().getDisabledReminders();
        for (String str : uuidsStr) {
            this.remindersEnabled.put(UUID.fromString(str), Boolean.FALSE);
        }
        this.plugin.getTimer().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                VoteReminding.this.saveReminds();
            }
        }, 24L, 24L, TimeUnit.HOURS);
    }

    public void runRemind(VotingPluginUser user) {
        if (this.plugin.getConfigFile().isVoteRemindingEnabled()) {
            if (this.plugin.getConfigFile().isUsePrimaryAccountForPlaceholders() && user.hasPrimaryAccount()) {
                user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(user.getPrimaryAccount());
            }
            this.giveReward(user);
            if (user.getData().hasData() && this.plugin.getConfigFile().isVoteRemindingRemindOnlyOnce() && !user.isReminded()) {
                user.setReminded(true);
            }
            this.plugin.debug(user.getPlayerName() + " was reminded!");
        }
    }

    public void runRemindLogin(VotingPluginUser user) {
        if (this.plugin.getConfigFile().isVoteRemindingEnabled()) {
            if (user.hasPermission("VotingPlugin.Login.RemindVotes") || user.hasPermission("VotingPlugin.Player")) {
                if (this.plugin.getConfigFile().isUsePrimaryAccountForPlaceholders() && user.hasPrimaryAccount()) {
                    user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(user.getPrimaryAccount());
                }
                if (!this.plugin.getVotingPluginUserManager().getAllUUIDs().contains(user.getUUID()) || this.shouldRemind(user)) {
                    this.giveReward(user);
                    if (user.getData().hasData() && !user.isReminded()) {
                        user.setReminded(true);
                    }
                    this.plugin.debug(user.getPlayerName() + " was reminded!");
                } else {
                    this.plugin.debug("Not reminding for " + user.getUUID());
                }
            } else {
                this.plugin.debug(user.getUUID() + " has no permission for reminders");
            }
        }
    }

    public void saveReminds() {
        ArrayList<UUID> remindersDisabled = new ArrayList<UUID>();
        for (Map.Entry<UUID, Boolean> entry : this.remindersEnabled.entrySet()) {
            if (!this.remindersEnabled.containsKey(entry.getKey()) || this.remindersEnabled.get(entry.getKey()).booleanValue()) continue;
            remindersDisabled.add(entry.getKey());
        }
        this.plugin.getServerData().saveDisabledReminders(remindersDisabled);
    }

    public boolean shouldRemind(VotingPluginUser user) {
        if (this.remindersEnabled.containsKey(user.getJavaUUID()) && !this.remindersEnabled.get(user.getJavaUUID()).booleanValue()) {
            return false;
        }
        if (!user.shouldBeReminded()) {
            this.plugin.debug(user.getUUID() + " no need to remind because player has VotingPlugin.NoRemind");
            return false;
        }
        boolean hasPermAll = user.hasPermission("VotingPlugin.Login.RemindVotes.All");
        if (hasPermAll) {
            return user.canVoteAll();
        }
        return user.canVoteAny();
    }

    @Generated
    public ConcurrentHashMap<UUID, Boolean> getRemindersEnabled() {
        return this.remindersEnabled;
    }
}

