/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.voteparty;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.api.time.events.DayChangeEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.MonthChangeEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.WeekChangeEvent;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.events.VotePartyEvent;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class VoteParty
implements Listener {
    private VotingPluginMain plugin;

    public VoteParty(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public void addTotal(VotingPluginUser user) {
        this.setTotalVotes(this.getTotalVotes() + 1);
        user.setVotePartyVotes(user.getVotePartyVotes() + 1);
        this.plugin.getPlaceholders().onVotePartyUpdate();
    }

    public void addVotePlayer(VotingPluginUser user) {
        String uuid = user.getUUID();
        List<String> voted = this.getVotedUsers();
        if (voted == null) {
            voted = new ArrayList<String>();
        }
        if (!voted.contains(uuid)) {
            voted.add(uuid);
            this.setVotedUsers(voted);
        }
    }

    public void check(VotingPluginUser user, boolean forceBungee) {
        if (this.getTotalVotes() < this.getVotesRequired()) {
            this.plugin.extraDebug("Not enough votes for vote party: " + this.getTotalVotes() + " / " + this.getVotesRequired());
            return;
        }
        if (this.plugin.getSpecialRewardsConfig().isVotePartyOnlyOncePerDay() && this.plugin.getServerData().isLastVotePartySameDay()) {
            this.plugin.extraDebug("Already had vote party today");
            return;
        }
        if (this.plugin.getSpecialRewardsConfig().isVotePartyOnlyOncePerWeek() && this.plugin.getServerData().isLastVotePartySameWeek()) {
            this.plugin.extraDebug("Already had vote party this week");
            return;
        }
        if (this.plugin.getSpecialRewardsConfig().isVotePartyResetCount()) {
            this.setTotalVotes(this.getTotalVotes() - this.getVotesRequired());
        }
        VotePartyEvent event = new VotePartyEvent();
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.giveRewards(user, forceBungee);
        if (this.plugin.getSpecialRewardsConfig().getVotePartyIncreaseVotesRequired() > 0) {
            this.plugin.getServerData().setVotePartyExtraRequired(this.plugin.getServerData().getVotePartyExtraRequired() + this.plugin.getSpecialRewardsConfig().getVotePartyIncreaseVotesRequired());
        }
        this.plugin.getServerData().updateLastVoteParty();
        if (this.plugin.getSpecialRewardsConfig().isVotePartyOnlyOncePerWeek()) {
            this.plugin.getServerData().updateLastVotePartyWeek();
        }
    }

    public void checkVoteReminder(VotingPluginUser user) {
        if (!user.isVanished()) {
            int neededVotes = this.getNeededVotes();
            for (Integer num1 : this.plugin.getSpecialRewardsConfig().getVotePartyVoteReminderAtVotes()) {
                int num = num1;
                if (neededVotes != num) continue;
                String broadcastMessage = this.plugin.getSpecialRewardsConfig().getVotePartyVoteReminderBroadcast();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", user.getPlayerName());
                placeholders.put("votesrequired", "" + neededVotes);
                MiscUtils.getInstance().broadcast(PlaceholderUtils.replacePlaceHolder(broadcastMessage, placeholders));
            }
        }
    }

    public void commandVoteParty(CommandSender sender) {
        if (this.plugin.getSpecialRewardsConfig().isVotePartyEnabled()) {
            ArrayList<String> msg = this.plugin.getConfigFile().getFormatCommandsVoteParty();
            int votesRequired = this.getVotesRequired();
            int votes = this.getTotalVotes();
            int neededVotes = votesRequired - votes;
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("votesrequired", "" + votesRequired);
            placeholders.put("neededvotes", "" + neededVotes);
            placeholders.put("votes", "" + votes);
            msg = ArrayUtils.colorize(PlaceholderUtils.replacePlaceHolder(msg, placeholders));
            if (sender instanceof Player) {
                Player p = (Player)sender;
                sender.sendMessage(ArrayUtils.convert(PlaceholderUtils.replacePlaceHolders(msg, p)));
            } else {
                sender.sendMessage(ArrayUtils.convert(msg));
            }
        } else {
            sender.sendMessage(MessageAPI.colorize("&cVoteParty not enabled"));
        }
    }

    public int getNeededVotes() {
        int votesRequired = this.getVotesRequired();
        int votes = this.getTotalVotes();
        int neededVotes = votesRequired - votes;
        return neededVotes;
    }

    public String getRandomPlayerName() {
        ArrayList<String> allPlayers = new ArrayList<String>();
        for (Player players : Bukkit.getOnlinePlayers()) {
            allPlayers.add(players.getName());
        }
        if (allPlayers.size() == 0) {
            return "No Player";
        }
        int random = new Random().nextInt(allPlayers.size());
        return (String)allPlayers.get(random);
    }

    public int getTotalVotes() {
        return this.plugin.getServerData().getData().getInt("VoteParty.Total");
    }

    public List<String> getVotedUsers() {
        List list = this.plugin.getServerData().getData().getStringList("VoteParty.Voted");
        if (list != null) {
            return list;
        }
        return new ArrayList<String>();
    }

    public int getVotesRequired() {
        int required = this.plugin.getSpecialRewardsConfig().getVotePartyVotesRequired();
        int extra = this.plugin.getServerData().getVotePartyExtraRequired();
        if (extra > 0) {
            return required + extra;
        }
        return required;
    }

    public void giveReward(VotingPluginUser user, boolean useBungee) {
        if (this.plugin.getSpecialRewardsConfig().getVotePartyUserVotesRequired() > 0 && user.getVotePartyVotes() < this.plugin.getSpecialRewardsConfig().getVotePartyUserVotesRequired()) {
            return;
        }
        this.giveReward(user, user.isOnline(), useBungee);
    }

    public void giveReward(VotingPluginUser user, boolean online, boolean useBungee) {
        new RewardBuilder((ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getVotePartyRewardsPath()).setOnline(online).withPlaceHolder("VotesRequired", "" + this.plugin.getSpecialRewardsConfig().getVotePartyVotesRequired()).withPlaceHolder("FirstVotePartyToday", "" + !this.plugin.getServerData().isLastVotePartySameDay()).setServer(useBungee).send((AdvancedCoreUser)user);
    }

    public void giveRewards(VotingPluginUser orgUser, boolean forceBungee) {
        MiscUtils.getInstance().broadcast(this.plugin.getSpecialRewardsConfig().getVotePartyBroadcast());
        final String player = this.getRandomPlayerName();
        for (final String cmd : this.plugin.getSpecialRewardsConfig().getVotePartyGlobalCommands()) {
            this.plugin.getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PlaceholderUtils.replacePlaceHolder(cmd, "randomonlineplayer", player));
                }
            });
        }
        final ArrayList<String> list = this.plugin.getSpecialRewardsConfig().getVotePartyGlobalRandomCommand();
        if (list.size() > 0) {
            this.plugin.getBukkitScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PlaceholderUtils.replacePlaceHolder((String)list.get(ThreadLocalRandom.current().nextInt(list.size())), "randomonlineplayer", player));
                }
            });
        }
        if (this.plugin.getSpecialRewardsConfig().isVotePartyGiveAllPlayers()) {
            VotingPluginUser user;
            this.plugin.debug("Trying to give all players vote party");
            ArrayList<String> alreadyGotten = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (orgUser != null && orgUser.getJavaUUID().equals(p.getUniqueId())) {
                    user = orgUser;
                } else {
                    user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(p);
                    user.dontCache();
                }
                if (!this.plugin.getSpecialRewardsConfig().isVotePartyGiveOnlinePlayersOnly() || user.isOnline()) {
                    this.giveReward(user, forceBungee);
                }
                alreadyGotten.add(p.getUniqueId().toString());
            }
            for (String uuid : this.plugin.getVotingPluginUserManager().getAllUUIDs()) {
                if (alreadyGotten.contains(uuid)) continue;
                if (orgUser != null && orgUser.getJavaUUID().toString().equals(uuid)) {
                    user = orgUser;
                } else {
                    user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid));
                    user.dontCache();
                }
                if (this.plugin.getSpecialRewardsConfig().isVotePartyGiveOnlinePlayersOnly() && !user.isOnline()) continue;
                this.giveReward(user, forceBungee);
            }
        } else {
            this.plugin.debug("Trying to give all voted players vote party");
            this.plugin.debug(ArrayUtils.makeStringList(this.getVotedUsers()));
            for (String uuid : this.getVotedUsers()) {
                VotingPluginUser user;
                if (orgUser != null && orgUser.getJavaUUID().toString().equals(uuid)) {
                    user = orgUser;
                } else {
                    user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid));
                    user.dontCache();
                }
                if (this.plugin.getSpecialRewardsConfig().isVotePartyGiveOnlinePlayersOnly() && !user.isOnline()) continue;
                this.giveReward(user, forceBungee);
            }
        }
        this.reset(false);
    }

    @EventHandler
    public void onDayChange(DayChangeEvent event) {
        if (this.plugin.getSpecialRewardsConfig().isVotePartyResetEachDay()) {
            this.reset(true);
        }
    }

    @EventHandler
    public void onMonthChange(MonthChangeEvent event) {
        if (this.plugin.getSpecialRewardsConfig().isVotePartyResetMonthly()) {
            this.reset(true);
        }
        if (this.plugin.getSpecialRewardsConfig().isVotePartyResetExtraVotesMonthly()) {
            this.plugin.getServerData().setVotePartyExtraRequired(0);
        }
    }

    @EventHandler
    public void onWeekChange(WeekChangeEvent event) {
        if (this.plugin.getSpecialRewardsConfig().isVotePartyResetWeekly()) {
            this.reset(true);
        }
        if (this.plugin.getSpecialRewardsConfig().isVotePartyResetExtraVotesWeekly()) {
            this.plugin.getServerData().setVotePartyExtraRequired(0);
        }
    }

    public void register() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void reset(boolean override) {
        if (override) {
            this.setTotalVotes(0);
        }
        this.setVotedUsers(new ArrayList<String>());
        this.resetVotePartyCount();
    }

    public void resetVotePartyCount() {
        this.plugin.getUserManager().removeAllKeyValues("VotePartyVotes", DataType.INTEGER);
    }

    public void setTotalVotes(int value) {
        this.plugin.getServerData().getData().set("VoteParty.Total", (Object)value);
        this.plugin.getServerData().saveData();
    }

    public void setVotedUsers(List<String> value) {
        this.plugin.getServerData().getData().set("VoteParty.Voted", value);
        this.plugin.getServerData().saveData();
    }

    public synchronized void vote(VotingPluginUser user, boolean realVote, boolean forceBungee) {
        if (this.plugin.getSpecialRewardsConfig().isVotePartyEnabled() && (this.plugin.getSpecialRewardsConfig().isVotePartyCountFakeVotes() || realVote) && (this.plugin.getSpecialRewardsConfig().isVotePartyCountOfflineVotes() || user.isOnline())) {
            this.addTotal(user);
            this.addVotePlayer(user);
            this.check(user, forceBungee);
            this.checkVoteReminder(user);
        }
    }
}

