/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.user;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.AdvancedCorePlugin;
import com.bencodez.votingplugin.advancedcore.api.messages.PlaceholderUtils;
import com.bencodez.votingplugin.advancedcore.api.misc.MiscUtils;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.events.PlayerReceivePointsEvent;
import com.bencodez.votingplugin.events.PlayerVoteEvent;
import com.bencodez.votingplugin.objects.VoteSite;
import com.bencodez.votingplugin.proxy.BungeeMessageData;
import com.bencodez.votingplugin.proxy.BungeeMethod;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValue;
import com.bencodez.votingplugin.simpleapi.sql.data.DataValueInt;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class VotingPluginUser
extends AdvancedCoreUser {
    private VotingPluginMain plugin;

    public VotingPluginUser(VotingPluginMain plugin, AdvancedCoreUser user) {
        super((AdvancedCorePlugin)plugin, user);
        this.plugin = plugin;
    }

    @Deprecated
    public VotingPluginUser(VotingPluginMain plugin, Player player) {
        super((AdvancedCorePlugin)plugin, player);
        this.plugin = plugin;
    }

    @Deprecated
    public VotingPluginUser(VotingPluginMain plugin, String playerName) {
        super((AdvancedCorePlugin)plugin, playerName);
        this.plugin = plugin;
    }

    @Deprecated
    public VotingPluginUser(VotingPluginMain plugin, UUID uuid) {
        super((AdvancedCorePlugin)plugin, uuid);
        this.plugin = plugin;
    }

    @Deprecated
    public VotingPluginUser(VotingPluginMain plugin, UUID uuid, boolean loadName) {
        super((AdvancedCorePlugin)plugin, uuid, loadName);
        this.plugin = plugin;
    }

    @Deprecated
    public VotingPluginUser(VotingPluginMain plugin, UUID uuid, String playerName) {
        super((AdvancedCorePlugin)plugin, uuid, playerName);
        this.plugin = plugin;
    }

    public void addAllTimeTotal() {
        this.setAllTimeTotal(this.getAllTimeTotal() + 1);
    }

    public void addDayVoteStreak() {
        this.setDayVoteStreak(this.getDayVoteStreak() + 1);
    }

    public void addMonthTotal() {
        this.setMonthTotal(this.getMonthTotal() + 1);
    }

    public void addMonthVoteStreak() {
        this.setMonthVoteStreak(this.getMonthVoteStreak() + 1);
    }

    public void addOfflineVote(String voteSiteName) {
        ArrayList<String> offlineVotes = this.getOfflineVotes();
        offlineVotes.add(voteSiteName);
        this.setOfflineVotes(offlineVotes);
    }

    public void addPoints() {
        int points = this.plugin.getConfigFile().getPointsOnVote();
        if (points != 0) {
            this.addPoints(points);
        }
        if (this.plugin.getConfigFile().getLimitVotePoints() > 0 && this.getPoints() > this.plugin.getConfigFile().getLimitVotePoints()) {
            this.setPoints(this.plugin.getConfigFile().getLimitVotePoints());
        }
    }

    public int addPoints(int value) {
        return this.addPoints(value, false);
    }

    public synchronized int addPoints(int value, boolean async) {
        PlayerReceivePointsEvent event = new PlayerReceivePointsEvent(this, value);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return this.getPoints();
        }
        int newTotal = this.getPoints() + event.getPoints();
        this.setPoints(newTotal, async);
        return newTotal;
    }

    public void addTotal() {
        this.setMilestoneCount(this.getMilestoneCount() + 1);
        this.addMonthTotal();
        this.addAllTimeTotal();
    }

    public void addTotalDaily() {
        this.setDailyTotal(this.getDailyTotal() + 1);
    }

    public void addTotalWeekly() {
        this.setWeeklyTotal(this.getWeeklyTotal() + 1);
    }

    public void addWeekVoteStreak() {
        this.setWeekVoteStreak(this.getWeekVoteStreak() + 1);
    }

    public void bungeeVote(String service, BungeeMessageData text, boolean setTotals) {
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            this.plugin.debug("Bungee vote for " + this.getPlayerName() + " on " + service);
            PlayerVoteEvent voteEvent = new PlayerVoteEvent(this.plugin.getVoteSite(service, true), this.getPlayerName(), service, true);
            voteEvent.setBungee(true);
            voteEvent.setForceBungee(true);
            voteEvent.setAddTotals(setTotals);
            voteEvent.setBungeeTextTotals(text);
            voteEvent.setVotingPluginUser(this);
            this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
        }
    }

    public void bungeeVoteOnline(String service, BungeeMessageData text, boolean setTotals) {
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            this.plugin.debug("Bungee online vote for " + this.getPlayerName() + " on " + service);
            PlayerVoteEvent voteEvent = new PlayerVoteEvent(this.plugin.getVoteSite(service, true), this.getPlayerName(), service, true);
            voteEvent.setBungee(true);
            voteEvent.setForceBungee(true);
            voteEvent.setAddTotals(setTotals);
            voteEvent.setBungeeTextTotals(text);
            voteEvent.setVotingPluginUser(this);
            this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
        }
    }

    public void bungeeVotePluginMessaging(String service, long time, BungeeMessageData text, boolean setTotals, boolean wasOnline, boolean broadcast, int num) {
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            this.plugin.debug("Pluginmessaging vote for " + this.getPlayerName() + " on " + service);
            PlayerVoteEvent voteEvent = new PlayerVoteEvent(this.plugin.getVoteSite(service, true), this.getPlayerName(), service, true);
            voteEvent.setBungee(true);
            voteEvent.setVotingPluginUser(this);
            voteEvent.setForceBungee(true);
            voteEvent.setTime(time);
            voteEvent.setAddTotals(setTotals);
            voteEvent.setBungeeTextTotals(text);
            voteEvent.setWasOnline(wasOnline);
            voteEvent.setBroadcast(broadcast);
            voteEvent.setVoteNumber(num);
            this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
        }
    }

    public boolean canVoteAll() {
        for (VoteSite voteSite : this.plugin.getVoteSitesEnabled()) {
            boolean canVote;
            if (voteSite.isHidden() || (canVote = this.canVoteSite(voteSite))) continue;
            return false;
        }
        return true;
    }

    public boolean canVoteAny() {
        for (VoteSite voteSite : this.plugin.getVoteSitesEnabled()) {
            boolean canVote;
            if (voteSite.isIgnoreCanVote() || voteSite.isHidden() || !(canVote = this.canVoteSite(voteSite))) continue;
            return true;
        }
        return false;
    }

    public boolean canVoteSite(VoteSite voteSite) {
        long time = this.getTime(voteSite);
        if (time == 0L) {
            return true;
        }
        try {
            LocalDateTime now = this.plugin.getTimeChecker().getTime();
            LocalDateTime lastVote = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()).plusHours(this.plugin.getOptions().getTimeHourOffSet());
            if (!voteSite.isVoteDelayDaily()) {
                double votedelay = voteSite.getVoteDelay();
                double voteDelayMin = voteSite.getVoteDelayMin();
                if (votedelay == 0.0 && voteDelayMin == 0.0) {
                    return false;
                }
                LocalDateTime nextvote = lastVote.plusHours((long)votedelay).plusMinutes((long)voteDelayMin);
                return now.isAfter(nextvote);
            }
            LocalDateTime resetTime = lastVote.withHour(voteSite.getVoteDelayDailyHour()).withMinute(0).withSecond(0);
            LocalDateTime resetTimeTomorrow = resetTime.plusHours(24L);
            if (lastVote.isBefore(resetTime) ? now.isAfter(resetTime) : now.isAfter(resetTimeTomorrow)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean checkAllVotes() {
        VotingPluginUser user = this;
        ArrayList<Integer> months = new ArrayList<Integer>();
        ArrayList<Integer> days = new ArrayList<Integer>();
        for (VoteSite voteSite : this.plugin.getVoteSitesEnabled()) {
            if (!voteSite.isEnabled() || voteSite.isHidden()) continue;
            long time = user.getTime(voteSite);
            if (time == 0L) {
                return false;
            }
            months.add(MiscUtils.getInstance().getMonthFromMili(time));
            days.add(MiscUtils.getInstance().getDayFromMili(time));
        }
        for (Integer month : months) {
            if (((Integer)months.get(0)).equals(month)) continue;
            return false;
        }
        for (Integer day : days) {
            if (((Integer)days.get(0)).equals(day)) continue;
            return false;
        }
        return true;
    }

    public boolean checkAlmostAllVotes() {
        return this.getSitesNotVotedOn() <= 1;
    }

    public void checkDayVoteStreak(boolean forceBungee) {
        if (!(this.voteStreakUpdatedToday(LocalDateTime.now()) || this.plugin.getSpecialRewardsConfig().isVoteStreakRequirementUsePercentage() && !this.hasPercentageTotal(TopVoter.Daily, this.plugin.getSpecialRewardsConfig().getVoteStreakRequirementDay(), null))) {
            this.plugin.extraDebug("Adding day vote streak to " + this.getUUID() + " " + this.plugin.getSpecialRewardsConfig().isVoteStreakRequirementUsePercentage() + " " + this.hasPercentageTotal(TopVoter.Daily, this.plugin.getSpecialRewardsConfig().getVoteStreakRequirementDay(), null));
            this.addDayVoteStreak();
            this.plugin.getSpecialRewards().checkVoteStreak(this, "Day", forceBungee);
            this.setDayVoteStreakLastUpdate(System.currentTimeMillis());
        }
    }

    public void clearOfflineVotes() {
        this.setOfflineVotes(new ArrayList<String>());
        this.setOfflineRewards(new ArrayList<String>());
    }

    public void clearTotals() {
        for (TopVoter top : TopVoter.values()) {
            this.resetTotals(top);
        }
    }

    @Deprecated
    public int getAllTimeTotal() {
        return this.getTotal(TopVoter.AllTime);
    }

    public int getBestDayVoteStreak() {
        return this.getData().getInt("BestDayVoteStreak", this.isCacheData(), this.isWaitForCache());
    }

    public int getBestMonthVoteStreak() {
        return this.getData().getInt("BestMonthVoteStreak", this.isCacheData(), this.isWaitForCache());
    }

    public int getBestWeekVoteStreak() {
        return this.getData().getInt("BestWeekVoteStreak", this.isCacheData(), this.isWaitForCache());
    }

    public boolean getCoolDownCheck() {
        return this.getData().getBoolean(this.getCoolDownCheckPath(), this.isCacheData(), this.isWaitForCache());
    }

    public String getCoolDownCheckPath() {
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            return "CoolDownCheck_" + this.plugin.getBungeeSettings().getServerNameStorage();
        }
        return "CoolDownCheck";
    }

    public boolean getCoolDownCheckSite(VoteSite site) {
        HashMap<String, Boolean> coolDownChecks = this.getCoolDownCheckSiteList();
        if (coolDownChecks.containsKey(site.getKey())) {
            return coolDownChecks.get(site.getKey());
        }
        return false;
    }

    public HashMap<String, Boolean> getCoolDownCheckSiteList() {
        HashMap<String, Boolean> coolDownChecks = new HashMap<String, Boolean>();
        ArrayList<String> coolDownCheck = this.getData().getStringList(this.getCoolDownCheckSitePath(), this.isCacheData(), this.isWaitForCache());
        for (String str : coolDownCheck) {
            VoteSite site;
            String[] data = str.split("//");
            if (data.length <= 1 || !this.plugin.hasVoteSite(data[0]) || (site = this.plugin.getVoteSite(data[0], true)) == null) continue;
            Boolean b = Boolean.valueOf(data[1]);
            coolDownChecks.put(site.getKey(), b);
        }
        return coolDownChecks;
    }

    public String getCoolDownCheckSitePath() {
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            return "CoolDownCheck_" + this.plugin.getBungeeSettings().getServerNameStorage() + "_Sites";
        }
        return "CoolDownCheck_Sites";
    }

    @Deprecated
    public int getDailyTotal() {
        return this.getTotal(TopVoter.Daily);
    }

    public int getDayVoteStreak() {
        return this.getData().getInt("DayVoteStreak", this.isCacheData(), this.isWaitForCache());
    }

    public long getDayVoteStreakLastUpdate() {
        String str = this.getData().getString("DayVoteStreakLastUpdate", this.isCacheData(), this.isWaitForCache());
        if (str == null || str.isEmpty() || str.equals("null")) {
            return 0L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public boolean getDisableBroadcast() {
        return this.getUserData().getBoolean("DisableBroadcast", this.isCacheData(), this.isWaitForCache());
    }

    public int getGottenAllSitesDay() {
        return this.getData().getInt(this.plugin.getVotingPluginUserManager().getGottenAllSitesDayPath(), 0, this.isWaitForCache());
    }

    public int getGottenAlmostAllSitesDay() {
        return this.getData().getInt(this.plugin.getVotingPluginUserManager().getGottenAlmostAllSitesDayPath(), 0, this.isWaitForCache());
    }

    public String getGottenMilestonesPath() {
        if (this.plugin.getBungeeSettings().isPerServerMilestones()) {
            return this.plugin.getBungeeSettings().getServerNameStorage() + "_GottenMilestones";
        }
        return "GottenMileStones";
    }

    public HashMap<String, Boolean> getHasGottenMilestone() {
        HashMap<String, Boolean> hasGottenMilestone = new HashMap<String, Boolean>();
        ArrayList<String> milestoneList = this.getUserData().getStringList(this.getGottenMilestonesPath());
        for (String str : milestoneList) {
            String[] data = str.split("//");
            if (data.length <= 1) continue;
            boolean gotten = Boolean.parseBoolean(data[1]);
            hasGottenMilestone.put(data[0], gotten);
        }
        return hasGottenMilestone;
    }

    public int getHighestDailyTotal() {
        return this.getData().getInt("HighestDailyTotal", this.isCacheData(), this.isWaitForCache());
    }

    public int getHighestMonthlyTotal() {
        return this.getData().getInt("HighestMonthlyTotal", this.isCacheData(), this.isWaitForCache());
    }

    public int getHighestWeeklyTotal() {
        return this.getData().getInt("HighestWeeklyTotal", this.isCacheData(), this.isWaitForCache());
    }

    public int getLastGottenMilestone() {
        Set<String> mVotes = this.plugin.getSpecialRewardsConfig().getMilestoneVotes();
        ArrayList<Integer> nums = new ArrayList<Integer>();
        int mileStoneCount = this.getMilestoneCount();
        for (String vote : mVotes) {
            if (!MessageAPI.isInt(vote)) continue;
            int num = Integer.parseInt(vote);
            if (!this.plugin.getSpecialRewardsConfig().getMilestoneRewardEnabled(num)) continue;
            nums.add(num);
        }
        int highestNum = -1;
        for (Integer num : nums) {
            if (mileStoneCount <= num || highestNum != -1 && num <= highestNum) continue;
            highestNum = num;
        }
        return highestNum;
    }

    public int getLastMonthTotal() {
        return this.getData().getInt("LastMonthTotal", this.isCacheData(), this.isWaitForCache());
    }

    public HashMap<VoteSite, Long> getLastVotes() {
        HashMap<VoteSite, Long> lastVotes = new HashMap<VoteSite, Long>();
        ArrayList<String> LastVotesList = this.getUserData().getStringList("LastVotes");
        for (String str : LastVotesList) {
            VoteSite site;
            String[] data = str.split("//");
            if (data.length <= 1 || !this.plugin.hasVoteSite(data[0]) || (site = this.plugin.getVoteSite(data[0], true)) == null) continue;
            long time = 0L;
            try {
                time = Long.parseLong(data[1]);
            }
            catch (NumberFormatException e) {
                time = 0L;
                this.plugin.debug("Not long: " + data[1]);
            }
            lastVotes.put(site, time);
        }
        return lastVotes;
    }

    public Long getLastVoteTime() {
        Long time = 0L;
        for (Long value : this.getLastVotes().values()) {
            if (value <= time) continue;
            time = value;
        }
        return time;
    }

    public long getLastVoteTimer(VoteSite voteSite) {
        HashMap<VoteSite, Long> times = this.getLastVotes();
        if (times.containsKey(voteSite)) {
            return times.get(voteSite);
        }
        return 0L;
    }

    public HashMap<VoteSite, Long> getLastVoteTimesSorted() {
        LinkedHashMap<VoteSite, Long> times = new LinkedHashMap<VoteSite, Long>();
        for (VoteSite voteSite : this.plugin.getVoteSitesEnabled()) {
            times.put(voteSite, this.getTime(voteSite));
        }
        LinkedHashMap<VoteSite, Long> sorted = new LinkedHashMap<VoteSite, Long>(times.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return sorted;
    }

    public int getMilestoneCount() {
        return this.getData().getInt("MilestoneCount", this.getAllTimeTotal(), this.isCacheData(), this.isWaitForCache());
    }

    @Deprecated
    public int getMonthTotal() {
        return this.getTotal(TopVoter.Monthly);
    }

    public int getMonthVoteStreak() {
        return this.getData().getInt("MonthVoteStreak", this.isCacheData(), this.isWaitForCache());
    }

    public int getNextAvailableMileStone() {
        Set<String> mVotes = this.plugin.getSpecialRewardsConfig().getMilestoneVotes();
        ArrayList<Integer> nums = new ArrayList<Integer>();
        int mileStoneCount = this.getMilestoneCount();
        HashMap<String, Boolean> gottenMileStones = this.getHasGottenMilestone();
        for (String vote : mVotes) {
            if (!MessageAPI.isInt(vote)) continue;
            int num = Integer.parseInt(vote);
            if (!this.plugin.getSpecialRewardsConfig().getMilestoneRewardEnabled(num)) continue;
            if (gottenMileStones.containsKey("" + num)) {
                if (gottenMileStones.get("" + num).booleanValue()) continue;
                nums.add(num);
                continue;
            }
            nums.add(num);
        }
        int lowestNum = -1;
        for (Integer num : nums) {
            if (mileStoneCount >= num || lowestNum != -1 && num >= lowestNum) continue;
            lowestNum = num;
        }
        return lowestNum;
    }

    public long getNextTimeAllSitesAvailable() {
        long longest = 0L;
        for (VoteSite site : this.plugin.getVoteSitesEnabled()) {
            long seconds = this.voteNextDurationTime(site);
            if (seconds <= longest) continue;
            longest = seconds;
        }
        return longest;
    }

    public long getNextTimeFirstSiteAvailable() {
        long shortest = 0L;
        for (VoteSite site : this.plugin.getVoteSitesEnabled()) {
            if (this.canVoteSite(site)) continue;
            long seconds = this.voteNextDurationTime(site);
            if (shortest != 0L && seconds >= shortest) continue;
            shortest = seconds;
        }
        return shortest;
    }

    public int getNumberOfOfflineVotes(VoteSite site) {
        ArrayList<String> offlineVotes = this.getOfflineVotes();
        int num = 0;
        for (String str : offlineVotes) {
            if (!str.equals(site.getKey())) continue;
            ++num;
        }
        return num;
    }

    public ArrayList<String> getOfflineVotes() {
        return this.getUserData().getStringList("OfflineVotes", this.isCacheData(), this.isWaitForCache());
    }

    public int getPoints() {
        return this.getUserData().getInt(this.getPointsPath(), this.isCacheData(), this.isWaitForCache());
    }

    public String getPointsPath() {
        if (this.plugin.getBungeeSettings().isPerServerPoints()) {
            return this.plugin.getBungeeSettings().getServerNameStorage() + "_Points";
        }
        return "Points";
    }

    public UUID getPrimaryAccount() {
        String s = this.getData().getString("PrimaryAccount", this.isCacheData(), this.isWaitForCache());
        if (s != null && !s.isEmpty()) {
            return UUID.fromString(s);
        }
        return null;
    }

    public int getSitesNotVotedOn() {
        int amount = 0;
        for (VoteSite site : this.plugin.getVoteSitesEnabled()) {
            if (site.isHidden() || !site.getPermissionToView().isEmpty() && !this.hasPermission(site.getPermissionToView()) || !this.canVoteSite(site)) continue;
            ++amount;
        }
        return amount;
    }

    public int getTotalNumberOfSites() {
        int amount = 0;
        for (VoteSite site : this.plugin.getVoteSitesEnabled()) {
            if (site.isHidden() || !site.getPermissionToView().isEmpty() && !this.hasPermission(site.getPermissionToView())) continue;
            ++amount;
        }
        return amount;
    }

    public int getSitesVotedOn() {
        int amount = 0;
        for (VoteSite site : this.plugin.getVoteSitesEnabled()) {
            if (this.canVoteSite(site)) continue;
            ++amount;
        }
        return amount;
    }

    public long getTime(VoteSite voteSite) {
        HashMap<VoteSite, Long> lastVotes = this.getLastVotes();
        if (lastVotes.containsKey(voteSite)) {
            return lastVotes.get(voteSite);
        }
        return 0L;
    }

    public TopVoterPlayer getTopVoterPlayer() {
        return new TopVoterPlayer(UUID.fromString(this.getUUID()), this.getPlayerName(), this.getLastOnline());
    }

    public int getTotal(TopVoter top) {
        switch (top) {
            case AllTime: {
                return this.getUserData().getInt("AllTimeTotal", this.isCacheData(), this.isWaitForCache());
            }
            case Daily: {
                return this.getUserData().getInt("DailyTotal", this.isCacheData(), this.isWaitForCache());
            }
            case Monthly: {
                if (this.plugin.getConfigFile().isUseMonthDateTotalsAsPrimaryTotal()) {
                    return this.getData().getInt(this.plugin.getVotingPluginUserManager().getMonthTotalsWithDatePath(), this.isCacheData(), this.isWaitForCache());
                }
                return this.getData().getInt("MonthTotal", this.isCacheData(), this.isWaitForCache());
            }
            case Weekly: {
                return this.getUserData().getInt("WeeklyTotal", this.isCacheData(), this.isWaitForCache());
            }
        }
        return 0;
    }

    public int getTotal(TopVoter top, LocalDateTime atTime) {
        switch (top) {
            case AllTime: {
                return this.getUserData().getInt("AllTimeTotal", this.isCacheData(), this.isWaitForCache());
            }
            case Daily: {
                return this.getUserData().getInt("DailyTotal", this.isCacheData(), this.isWaitForCache());
            }
            case Monthly: {
                if (this.plugin.getConfigFile().isUseMonthDateTotalsAsPrimaryTotal()) {
                    return this.getData().getInt(this.plugin.getVotingPluginUserManager().getMonthTotalsWithDatePath(atTime), this.isCacheData(), this.isWaitForCache());
                }
                return this.getData().getInt("MonthTotal", this.isCacheData(), this.isWaitForCache());
            }
            case Weekly: {
                return this.getUserData().getInt("WeeklyTotal", this.isCacheData(), this.isWaitForCache());
            }
        }
        return 0;
    }

    public int getVotePartyVotes() {
        return this.getUserData().getInt("VotePartyVotes", this.isCacheData(), this.isWaitForCache());
    }

    public int getVoteShopIdentifierLimit(String identifier) {
        return this.getData().getInt("VoteShopLimit" + identifier, this.isCacheData(), this.isWaitForCache());
    }

    @Deprecated
    public int getWeeklyTotal() {
        return this.getTotal(TopVoter.Weekly);
    }

    public int getWeekVoteStreak() {
        return this.getData().getInt("WeekVoteStreak", this.isCacheData(), this.isWaitForCache());
    }

    public void giveDailyTopVoterAward(int place, String path) {
        new RewardBuilder((ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getDailyAwardRewardsPath(path)).withPlaceHolder("place", "" + place).withPlaceHolder("topvoter", "Daily").withPlaceHolder("votes", "" + this.getTotal(TopVoter.Daily)).setOnline(this.isOnline()).send((AdvancedCoreUser)this);
    }

    public void giveMonthlyTopVoterAward(int place, String path) {
        new RewardBuilder((ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getMonthlyAwardRewardsPath(path)).withPlaceHolder("place", "" + place).withPlaceHolder("topvoter", "Monthly").withPlaceHolder("votes", "" + this.getTotal(TopVoter.Monthly)).setOnline(this.isOnline()).send((AdvancedCoreUser)this);
    }

    public void giveWeeklyTopVoterAward(int place, String path) {
        new RewardBuilder((ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getWeeklyAwardRewardsPath(path)).withPlaceHolder("place", "" + place).withPlaceHolder("topvoter", "Weekly").withPlaceHolder("votes", "" + this.getTotal(TopVoter.Weekly)).setOnline(this.isOnline()).send((AdvancedCoreUser)this);
    }

    public boolean hasGottenFirstVote() {
        if (this.plugin.getBungeeSettings().isUseBungeecoord() && this.plugin.getBungeeHandler().getMethod().equals((Object)BungeeMethod.PLUGINMESSAGING)) {
            return this.getTotal(TopVoter.AllTime) > 1;
        }
        return this.getTotal(TopVoter.AllTime) != 0;
    }

    public boolean hasGottenFirstVoteToday() {
        if (this.plugin.getBungeeSettings().isUseBungeecoord() && this.plugin.getBungeeHandler().getMethod().equals((Object)BungeeMethod.PLUGINMESSAGING)) {
            return this.getTotal(TopVoter.Daily) > 1;
        }
        return this.getTotal(TopVoter.Daily) != 0;
    }

    public boolean hasGottenMilestone(int votesRequired) {
        HashMap<String, Boolean> hasGottenMilestone = this.getHasGottenMilestone();
        if (hasGottenMilestone.containsKey("" + votesRequired)) {
            return hasGottenMilestone.get("" + votesRequired);
        }
        return false;
    }

    public boolean hasPercentageTotal(TopVoter top, double percentage, LocalDateTime time) {
        int total = this.getTotal(top, time);
        switch (top) {
            case Daily: {
                return (double)total / (double)this.plugin.getVoteSitesEnabled().size() * 100.0 > percentage;
            }
            case Monthly: {
                return (double)total / ((double)this.plugin.getVoteSitesEnabled().size() * (double)time.getMonth().length(false)) * 100.0 > percentage;
            }
            case Weekly: {
                return (double)total / ((double)this.plugin.getVoteSitesEnabled().size() * 7.0) * 100.0 > percentage;
            }
        }
        return false;
    }

    public boolean hasPrimaryAccount() {
        return this.getPrimaryAccount() != null;
    }

    public boolean isReminded() {
        return this.getUserData().getBoolean("Reminded");
    }

    public boolean isTopVoterIgnore() {
        return this.getUserData().getBoolean("TopVoterIgnore");
    }

    public void loginMessage() {
        if (this.plugin.getConfigFile().isVoteRemindingRemindOnLogin()) {
            this.plugin.getVoteReminding().runRemindLogin(this);
        }
    }

    public void loginRewards() {
        if (this.plugin.getRewardHandler().hasRewards(this.plugin.getSpecialRewardsConfig().getData(), "LoginRewards")) {
            new RewardBuilder((ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), "LoginRewards").send((AdvancedCoreUser)this);
        }
    }

    public void logoutRewards() {
        if (this.plugin.getRewardHandler().hasRewards(this.plugin.getSpecialRewardsConfig().getData(), "LogoutRewards")) {
            new RewardBuilder((ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), "LogoutRewards").send((AdvancedCoreUser)this);
        }
    }

    public void mergeData(HashMap<String, DataValue> toAdd) {
        HashMap<String, DataValue> currentData = this.getData().getValues();
        HashMap<String, DataValue> newData = new HashMap<String, DataValue>();
        for (TopVoter top : TopVoter.values()) {
            if (!toAdd.containsKey(top.getColumnName()) || !currentData.containsKey(top.getColumnName())) continue;
            newData.put(top.getColumnName(), new DataValueInt(currentData.get(top.getColumnName()).getInt() + toAdd.get(top.getColumnName()).getInt()));
        }
        if (newData.size() > 0) {
            this.getData().setValues(newData);
        }
    }

    public void offlineBroadcast(VotingPluginUser user, boolean checkBungee, int numberOfVotes) {
        if (this.plugin.getConfigFile().isFormatAlternateBroadcastEnabled()) {
            return;
        }
        if (!user.isVanished()) {
            String playerName = user.getPlayerName();
            if (this.plugin.getConfigFile().getVotingBroadcastBlacklist().contains(playerName)) {
                this.plugin.getLogger().info("Not broadcasting for " + playerName + ", in blacklist");
                return;
            }
            if (checkBungee && this.plugin.getBungeeSettings().isBungeeBroadcast() && this.plugin.getBungeeSettings().isUseBungeecoord()) {
                if (this.plugin.getBungeeHandler().getMethod().equals((Object)BungeeMethod.SOCKETS)) {
                    this.plugin.getBungeeHandler().sendData("BroadcastOffline", "" + numberOfVotes, user.getPlayerName());
                } else if (this.plugin.getBungeeHandler().getMethod().equals((Object)BungeeMethod.MYSQL) || this.plugin.getBungeeHandler().getMethod().equals((Object)BungeeMethod.PLUGINMESSAGING)) {
                    String uuid = user.getUUID();
                    if (Bukkit.getOnlinePlayers().size() > 0) {
                        this.plugin.getPluginMessaging().sendPluginMessage("VoteBroadcastOffline", uuid, "" + numberOfVotes);
                    }
                }
            } else {
                String bc = MessageAPI.colorize(this.plugin.getConfigFile().getFormatOfflineBroadcast());
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("player", playerName);
                placeholders.put("nickname", user.getPlayer() != null ? user.getPlayer().getDisplayName() : user.getPlayerName());
                placeholders.put("numberofvotes", "" + numberOfVotes);
                bc = PlaceholderUtils.replacePlaceHolder(bc, placeholders);
                bc = PlaceholderUtils.replacePlaceHolders(user.getOfflinePlayer(), bc);
                ArrayList<Player> players = new ArrayList<Player>();
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (this.plugin.getVotingPluginUserManager().getVotingPluginUser(p).getDisableBroadcast()) continue;
                    players.add(p);
                }
                MiscUtils.getInstance().broadcast(bc, players);
            }
        } else {
            this.plugin.debug(user.getPlayerName() + " is vanished, not broadcasting");
        }
    }

    public void offVote() {
        ArrayList<String> offlineVotes;
        if (!this.plugin.getOptions().isProcessRewards()) {
            this.plugin.debug("Processing rewards is disabled");
            return;
        }
        Player player = this.getPlayer();
        if (!this.plugin.getOptions().isOnlineMode()) {
            player = Bukkit.getPlayer((String)this.getPlayerName());
        }
        if (player == null) {
            return;
        }
        this.plugin.extraDebug("Checking offline votes for " + player.getName() + "/" + this.getUUID());
        boolean currentTopVoterIgnore = player.hasPermission("VotingPlugin.TopVoter.Ignore");
        if (this.isTopVoterIgnore() != currentTopVoterIgnore) {
            this.setTopVoterIgnore(currentTopVoterIgnore);
        }
        if ((offlineVotes = this.getOfflineVotes()).isEmpty()) {
            return;
        }
        this.sendVoteEffects(false);
        this.setOfflineVotes(new ArrayList<String>());
        boolean offlineBroadcastEnabled = this.plugin.getConfigFile().isFormatOnlyOneOfflineBroadcast();
        if (offlineBroadcastEnabled) {
            this.offlineBroadcast(this, this.plugin.getBungeeSettings().isUseBungeecoord(), offlineVotes.size());
        }
        for (String voteSiteName : offlineVotes) {
            if (this.plugin.hasVoteSite(voteSiteName)) {
                this.plugin.debug("Giving offline site reward: " + voteSiteName);
                this.playerVote(this.plugin.getVoteSite(voteSiteName, true), false, !offlineBroadcastEnabled, false);
                continue;
            }
            this.plugin.debug("Site doesn't exist: " + voteSiteName);
        }
    }

    public void playerVote(VoteSite voteSite, boolean online, boolean broadcast, boolean bungee) {
        if (this.plugin.getConfigFile().isFormatBroadcastWhenOnline() && this.plugin.getConfigFile().isBroadcastVotesEnabled() && broadcast && !this.plugin.getBungeeSettings().isDisableBroadcast()) {
            voteSite.broadcastVote(this);
        }
        voteSite.giveRewards(this, online, bungee);
    }

    public boolean removePoints(int points) {
        if (this.getPoints() >= points) {
            this.setPoints(this.getPoints() - points);
            return true;
        }
        return false;
    }

    public boolean removePoints(int points, boolean async) {
        if (this.getPoints() >= points) {
            this.setPoints(this.getPoints() - points, async);
            return true;
        }
        return false;
    }

    public void resetLastVoted() {
        HashMap<VoteSite, Long> map = this.getLastVotes();
        for (Map.Entry<VoteSite, Long> e : map.entrySet()) {
            e.setValue(0L);
        }
        this.setLastVotes(map);
    }

    public void resetLastVoted(VoteSite site) {
        HashMap<VoteSite, Long> map = this.getLastVotes();
        map.put(site, 0L);
        this.setLastVotes(map);
    }

    public void resetTotals(TopVoter topVoter) {
        this.setTotal(topVoter, 0);
    }

    public void sendVoteEffects(boolean online) {
        this.plugin.getRewardHandler().giveReward(this, (ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getAnySiteRewardsPath(), new RewardOptions().setOnline(online));
    }

    @Deprecated
    public void setAllTimeTotal(int allTimeTotal) {
        this.setTotal(TopVoter.AllTime, allTimeTotal);
    }

    public void setBestDayVoteStreak(int streak) {
        this.getData().setInt("BestDayVoteStreak", streak);
    }

    public void setBestMonthVoteStreak(int streak) {
        this.getData().setInt("BestMonthVoteStreak", streak);
    }

    public void setBestWeekVoteStreak(int streak) {
        this.getData().setInt("BestWeekVoteStreak", streak);
    }

    public void setCoolDownCheck(boolean coolDownCheck) {
        this.getData().setBoolean(this.getCoolDownCheckPath(), coolDownCheck);
    }

    public void setCoolDownCheckSite(HashMap<String, Boolean> coolDownChecks) {
        ArrayList<String> data = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : coolDownChecks.entrySet()) {
            String str = entry.getKey() + "//" + entry.getValue().toString();
            data.add(str);
        }
        this.getUserData().setStringList(this.getCoolDownCheckSitePath(), data);
    }

    public void setCoolDownCheckSite(VoteSite site, boolean value) {
        HashMap<String, Boolean> coolDownChecks = this.getCoolDownCheckSiteList();
        coolDownChecks.put(site.getKey(), value);
        this.setCoolDownCheckSite(coolDownChecks);
    }

    @Deprecated
    public void setDailyTotal(int total) {
        this.setTotal(TopVoter.Daily, total);
    }

    public void setDayVoteStreak(int streak) {
        this.getData().setInt("DayVoteStreak", streak);
        if (this.getBestDayVoteStreak() < streak) {
            this.setBestDayVoteStreak(streak);
        }
    }

    public void setDayVoteStreakLastUpdate(long time) {
        this.getData().setString("DayVoteStreakLastUpdate", "" + time);
    }

    public void setDisableBroadcast(boolean value) {
        this.getUserData().setBoolean("DisableBroadcast", value);
    }

    public void setGottenAllSitesDay(int day) {
        this.getData().setInt(this.plugin.getVotingPluginUserManager().getGottenAllSitesDayPath(), day);
    }

    public void setGottenAlmostAllSitesDay(int day) {
        this.getData().setInt(this.plugin.getVotingPluginUserManager().getGottenAlmostAllSitesDayPath(), day);
    }

    public void setHasGotteMilestone(int votesRequired, boolean b) {
        HashMap<String, Boolean> hasGottenMilestone = this.getHasGottenMilestone();
        hasGottenMilestone.put("" + votesRequired, b);
        this.setHasGottenMilestone(hasGottenMilestone);
    }

    public void setHasGottenMilestone(HashMap<String, Boolean> hasGottenMilestone) {
        ArrayList<String> data = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : hasGottenMilestone.entrySet()) {
            String str = entry.getKey() + "//" + entry.getValue();
            data.add(str);
        }
        this.getUserData().setStringList(this.getGottenMilestonesPath(), data);
    }

    public void setHighestDailyTotal(int total) {
        this.getData().setInt("HighestDailyTotal", total);
    }

    public void setHighestMonthlyTotal(int total) {
        this.getData().setInt("HighestMonthlyTotal", total);
    }

    public void setHighestWeeklyTotal(int total) {
        this.getData().setInt("HighestWeeklyTotal", total);
    }

    public void setLastMonthTotal(int total) {
        this.getData().setInt("LastMonthTotal", total);
    }

    public void setLastVotes(HashMap<VoteSite, Long> lastVotes) {
        ArrayList<String> data = new ArrayList<String>();
        for (Map.Entry<VoteSite, Long> entry : lastVotes.entrySet()) {
            String str = entry.getKey().getKey() + "//" + entry.getValue();
            data.add(str);
        }
        this.getUserData().setStringList("LastVotes", data);
    }

    public void setMilestoneCount(int value) {
        this.getData().setInt("MilestoneCount", value);
    }

    @Deprecated
    public void setMonthTotal(int total) {
        this.setTotal(TopVoter.Monthly, total);
    }

    public void setMonthVoteStreak(int streak) {
        this.getData().setInt("MonthVoteStreak", streak);
        if (this.getBestMonthVoteStreak() < streak) {
            this.setBestMonthVoteStreak(streak);
        }
    }

    public void setOfflineVotes(ArrayList<String> offlineVotes) {
        this.getUserData().setStringList("OfflineVotes", offlineVotes);
    }

    public void setPoints(int value) {
        this.getUserData().setInt(this.getPointsPath(), value, false);
    }

    public void setPoints(int value, boolean async) {
        this.getUserData().setInt(this.getPointsPath(), value, false, async);
    }

    public void setPrimaryAccount(UUID uuid) {
        if (uuid != null) {
            this.getData().setString("PrimaryAccount", uuid.toString());
        } else {
            this.getData().setString("PrimaryAccount", "");
        }
    }

    public void setReminded(boolean reminded) {
        this.getUserData().setString("Reminded", "" + reminded);
    }

    public void setTime(VoteSite voteSite) {
        this.setTime(voteSite, LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public void setTime(VoteSite voteSite, Long time) {
        HashMap<VoteSite, Long> lastVotes = this.getLastVotes();
        if (lastVotes != null && lastVotes.containsKey(voteSite) && lastVotes.get(voteSite).longValue() == time.longValue()) {
            this.plugin.debug("Not setting last vote time for " + voteSite.getKey() + ", already set to " + time);
            return;
        }
        lastVotes.put(voteSite, time);
        this.setLastVotes(lastVotes);
    }

    public void setTopVoterIgnore(boolean topVoterIgnore) {
        this.getUserData().setString("TopVoterIgnore", "" + topVoterIgnore);
    }

    public void setTotal(TopVoter top, int value) {
        switch (top) {
            case AllTime: {
                this.getUserData().setInt("AllTimeTotal", value);
                break;
            }
            case Daily: {
                this.getUserData().setInt("DailyTotal", value);
                break;
            }
            case Monthly: {
                LocalDateTime time;
                int days;
                if (this.plugin.getConfigFile().isLimitMonthlyVotes() && value >= (days = (time = this.plugin.getTimeChecker().getTime()).getDayOfMonth()) * this.plugin.getVoteSitesEnabled().size()) {
                    value = days * this.plugin.getVoteSitesEnabled().size();
                }
                this.getData().setInt("MonthTotal", value);
                if (!this.plugin.getConfigFile().isStoreMonthTotalsWithDate()) break;
                this.getData().setInt(this.plugin.getVotingPluginUserManager().getMonthTotalsWithDatePath(), value);
                break;
            }
            case Weekly: {
                this.getUserData().setInt("WeeklyTotal", value);
                break;
            }
        }
    }

    public void setVotePartyVotes(int value) {
        this.getUserData().setInt("VotePartyVotes", value);
    }

    public void setVoteShopIdentifierLimit(String identifier, int value) {
        this.getData().setInt("VoteShopLimit" + identifier, value);
    }

    @Deprecated
    public void setWeeklyTotal(int total) {
        this.setTotal(TopVoter.Weekly, total);
    }

    public void setWeekVoteStreak(int streak) {
        this.getData().setInt("WeekVoteStreak", streak);
        if (this.getBestWeekVoteStreak() < streak) {
            this.setBestWeekVoteStreak(streak);
        }
    }

    public boolean shouldBeReminded() {
        Player player = this.getPlayer();
        return player == null || !player.hasPermission("VotingPlugin.NoRemind");
    }

    @Deprecated
    public String voteCommandLastDate(VoteSite voteSite) {
        long time = this.getTime(voteSite);
        if (time > 0L) {
            Date date = new Date(time);
            String timeString = new SimpleDateFormat(this.plugin.getConfigFile().getFormatTimeFormat()).format(date);
            if (MessageAPI.containsIgnorecase(timeString, "YamlConfiguration")) {
                this.plugin.getLogger().warning("Detected issue parsing time, check time format");
            }
            return timeString;
        }
        return "";
    }

    public String voteCommandLastDuration(VoteSite voteSite) {
        long time = this.getTime(voteSite);
        if (time > 0L) {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime lastVote = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
            Duration dur = Duration.between(lastVote, now);
            long diffSecond = dur.getSeconds();
            int diffDays = (int)(diffSecond / 60L / 60L / 24L);
            int diffHours = (int)(diffSecond / 60L / 60L - (long)(diffDays * 24));
            int diffMinutes = (int)(diffSecond / 60L - (long)(diffHours * 60) - (long)(diffDays * 24 * 60));
            int diffSeconds = (int)(diffSecond - (long)(diffMinutes * 60) - (long)(diffHours * 60 * 60) - (long)(diffDays * 24 * 60 * 60));
            String info = "";
            if (diffDays == 1) {
                info = info + PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastTimeFormat(), "TimeType", this.plugin.getConfigFile().getFormatTimeFormatsDay()), "amount", "" + diffDays);
                info = info + " ";
            } else if (diffDays > 1) {
                info = info + PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastTimeFormat(), "TimeType", this.plugin.getConfigFile().getFormatTimeFormatsDays()), "amount", "" + diffDays);
                info = info + " ";
            }
            if (diffHours == 1) {
                info = info + PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastTimeFormat(), "TimeType", this.plugin.getConfigFile().getFormatTimeFormatsHour()), "amount", "" + diffHours);
                info = info + " ";
            } else if (diffHours > 1) {
                info = info + PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastTimeFormat(), "TimeType", this.plugin.getConfigFile().getFormatTimeFormatsHours()), "amount", "" + diffHours);
                info = info + " ";
            }
            if (diffMinutes == 1) {
                info = info + PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastTimeFormat(), "TimeType", this.plugin.getConfigFile().getFormatTimeFormatsMinute()), "amount", "" + diffMinutes);
                info = info + " ";
            } else if (diffMinutes > 1) {
                info = info + PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastTimeFormat(), "TimeType", this.plugin.getConfigFile().getFormatTimeFormatsMinutes()), "amount", "" + diffMinutes);
                info = info + " ";
            }
            if (this.plugin.getConfigFile().isFormatCommandsVoteLastIncludeSeconds()) {
                info = diffSeconds == 1 ? info + PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastTimeFormat(), "TimeType", this.plugin.getConfigFile().getFormatTimeFormatsSecond()), "amount", "" + diffSeconds) : info + PlaceholderUtils.replacePlaceHolder(PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastTimeFormat(), "TimeType", this.plugin.getConfigFile().getFormatTimeFormatsSeconds()), "amount", "" + diffSeconds);
            }
            info = PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastLastVoted(), "times", info);
            return info;
        }
        return this.plugin.getConfigFile().getFormatCommandsVoteLastNeverVoted();
    }

    public String voteCommandLastGUILine(VoteSite voteSite) {
        String timeString = this.voteCommandLastDate(voteSite);
        String timeSince = this.voteCommandLastDuration(voteSite);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("time", timeString);
        placeholders.put("SiteName", voteSite.getDisplayName());
        placeholders.put("timesince", timeSince);
        return PlaceholderUtils.replacePlaceHolder(this.plugin.getGui().getChestVoteLastLine(), placeholders);
    }

    public String voteCommandLastLine(VoteSite voteSite) {
        String timeString = this.voteCommandLastDate(voteSite);
        String timeSince = this.voteCommandLastDuration(voteSite);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("time", timeString);
        placeholders.put("SiteName", voteSite.getDisplayName());
        placeholders.put("timesince", timeSince);
        return PlaceholderUtils.replacePlaceHolder(this.plugin.getConfigFile().getFormatCommandsVoteLastLine(), placeholders);
    }

    public String voteCommandNextInfo(VoteSite voteSite) {
        return this.voteCommandNextInfo(voteSite, this.getTime(voteSite));
    }

    public String voteCommandNextInfo(VoteSite voteSite, long time) {
        String info = new String();
        long nextTime = this.voteNextDurationTime(voteSite, time);
        if (nextTime == 0L) {
            info = this.plugin.getConfigFile().getFormatCommandsVoteNextInfoCanVote();
        } else {
            int diffHours = (int)(nextTime / 3600L);
            long diffMinutes = nextTime / 60L - (long)(diffHours * 60);
            if (diffHours < 0) {
                diffHours *= -1;
            }
            if (diffHours >= 24) {
                diffHours -= 24;
            }
            if (diffMinutes < 0L) {
                diffMinutes *= -1L;
            }
            String timeMsg = this.plugin.getConfigFile().getFormatCommandsVoteNextInfoVoteDelayDaily();
            timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%hours%", Integer.toString(diffHours));
            info = timeMsg = MessageAPI.replaceIgnoreCase(timeMsg, "%minutes%", Long.toString(diffMinutes));
        }
        return info;
    }

    public long voteNextDurationTime(VoteSite voteSite) {
        return this.voteNextDurationTime(voteSite, this.getTime(voteSite));
    }

    public long voteNextDurationTime(VoteSite voteSite, long time) {
        LocalDateTime now = this.plugin.getTimeChecker().getTime();
        LocalDateTime lastVote = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault()).plusHours(this.plugin.getOptions().getTimeHourOffSet());
        if (!voteSite.isVoteDelayDaily()) {
            double votedelay = voteSite.getVoteDelay();
            if (votedelay == 0.0 && voteSite.getVoteDelayMin() == 0.0) {
                return 0L;
            }
            LocalDateTime nextvote = lastVote.plusHours((long)votedelay).plusMinutes((long)voteSite.getVoteDelayMin());
            if (time == 0L || now.isAfter(nextvote)) {
                return 0L;
            }
            Duration dur = Duration.between(now, nextvote);
            return dur.getSeconds();
        }
        LocalDateTime resetTime = lastVote.withHour(voteSite.getVoteDelayDailyHour()).withMinute(0).withSecond(0);
        LocalDateTime resetTimeTomorrow = resetTime.plusHours(24L);
        if (lastVote.isBefore(resetTime)) {
            if (now.isBefore(resetTime)) {
                Duration dur = Duration.between(now, resetTime);
                return dur.getSeconds();
            }
        } else if (now.isBefore(resetTimeTomorrow)) {
            Duration dur = Duration.between(now, resetTimeTomorrow);
            return dur.getSeconds();
        }
        return 0L;
    }

    public boolean voteStreakUpdatedToday(LocalDateTime time) {
        return MiscUtils.getInstance().getTime(this.getDayVoteStreakLastUpdate()).getDayOfYear() == time.getDayOfYear();
    }
}

