/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.user;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.advancedcore.api.user.UserStartup;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.UserDataManager;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKeyBoolean;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKeyInt;
import com.bencodez.votingplugin.advancedcore.api.user.usercache.keys.UserDataKeyString;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class UserManager {
    private VotingPluginMain plugin;

    public UserManager(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public void addCachingKeys() {
        UserDataManager manager = this.plugin.getUserManager().getDataManager();
        manager.addKey(new UserDataKeyBoolean("TopVoterIgnore"));
        manager.addKey(new UserDataKeyInt("VotePartyVotes"));
        manager.addKey(new UserDataKeyString("LastVotes"));
        manager.addKey(new UserDataKeyBoolean(this.getCoolDownCheckPath()));
        manager.addKey(new UserDataKeyString("OfflineVotes").setColumnType("MEDIUMTEXT"));
        manager.addKey(new UserDataKeyInt("MilestoneCount"));
        manager.addKey(new UserDataKeyInt("MonthTotal"));
        if (this.plugin.getConfigFile().isUseMonthDateTotalsAsPrimaryTotal()) {
            manager.addKey(new UserDataKeyInt(this.getMonthTotalsWithDatePath(LocalDateTime.now().minusMonths(1L))));
            manager.addKey(new UserDataKeyInt(this.getMonthTotalsWithDatePath(LocalDateTime.now())));
            manager.addKey(new UserDataKeyInt(this.getMonthTotalsWithDatePath(LocalDateTime.now().plusMonths(1L))));
            manager.addKey(new UserDataKeyInt(this.getMonthTotalsWithDatePath(LocalDateTime.now().plusMonths(2L))));
        }
        manager.addKey(new UserDataKeyInt("AllTimeTotal"));
        manager.addKey(new UserDataKeyInt("DailyTotal"));
        manager.addKey(new UserDataKeyInt("WeeklyTotal"));
        manager.addKey(new UserDataKeyInt("Points"));
        manager.addKey(new UserDataKeyInt("DayVoteStreak"));
        manager.addKey(new UserDataKeyInt("BestDayVoteStreak"));
        manager.addKey(new UserDataKeyString("DayVoteStreakLastUpdate").setColumnType("MEDIUMTEXT"));
        manager.addKey(new UserDataKeyString("GottenMileStones").setColumnType("LONGTEXT"));
        manager.addKey(new UserDataKeyBoolean("Reminded"));
        manager.addKey(new UserDataKeyBoolean("DisableBroadcast"));
        manager.addKey(new UserDataKeyInt("WeekVoteStreak"));
        manager.addKey(new UserDataKeyInt("BestWeekVoteStreak"));
        manager.addKey(new UserDataKeyInt("MonthVoteStreak"));
        manager.addKey(new UserDataKeyInt("HighestDailyTotal"));
        manager.addKey(new UserDataKeyInt("HighestMonthlyTotal"));
        manager.addKey(new UserDataKeyInt("HighestWeeklyTotal"));
        manager.addKey(new UserDataKeyInt("LastMonthTotal"));
        manager.addKey(new UserDataKeyInt("LastWeeklyTotal"));
        manager.addKey(new UserDataKeyInt("LastDailyTotal"));
        manager.addKey(new UserDataKeyInt("BestMonthVoteStreak"));
        manager.addKey(new UserDataKeyString(this.getCoolDownCheckSitePath()).setColumnType("LONGTEXT"));
        if (this.plugin.getOptions().isPerServerRewards()) {
            manager.addKey(new UserDataKeyString("OfflineRewards" + this.plugin.getOptions().getServer()).setColumnType("MEDIUMTEXT"));
        }
        if (this.plugin.getConfigFile().isExtraAllSitesCheck()) {
            manager.addKey(new UserDataKeyInt(this.getGottenAllSitesDayPath()));
        }
        manager.addKey(new UserDataKeyInt(this.getGottenAlmostAllSitesDayPath()));
    }

    public ArrayList<String> getAllUUIDs() {
        return this.plugin.getUserManager().getAllUUIDs();
    }

    public String getCoolDownCheckPath() {
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            return "CoolDownCheck_" + this.plugin.getBungeeSettings().getServerNameStorage();
        }
        return "CoolDownCheck";
    }

    public String getCoolDownCheckSitePath() {
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            return "CoolDownCheck_" + this.plugin.getBungeeSettings().getServerNameStorage() + "_Sites";
        }
        return "CoolDownCheck_Sites";
    }

    public String getGottenAllSitesDayPath() {
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            return "AllSitesLast_" + this.plugin.getBungeeSettings().getServerNameStorage();
        }
        return "AllSitesLast";
    }

    public String getGottenAlmostAllSitesDayPath() {
        if (this.plugin.getBungeeSettings().isUseBungeecoord()) {
            return "AlmostAllSitesLast_" + this.plugin.getBungeeSettings().getServerNameStorage();
        }
        return "AlmostAllSitesLast";
    }

    public String getMonthTotalsWithDatePath() {
        LocalDateTime cTime = this.plugin.getTimeChecker().getTime();
        return this.getMonthTotalsWithDatePath(cTime);
    }

    public String getMonthTotalsWithDatePath(LocalDateTime cTime) {
        return "MonthTotal-" + cTime.getMonth().toString() + "-" + cTime.getYear();
    }

    public VotingPluginUser getVotingPluginUser(AdvancedCoreUser user) {
        return new VotingPluginUser(this.plugin, user);
    }

    public VotingPluginUser getVotingPluginUser(OfflinePlayer player) {
        return this.getVotingPluginUser(player.getUniqueId(), player.getName());
    }

    public VotingPluginUser getVotingPluginUser(Player player) {
        return this.getVotingPluginUser(player.getUniqueId(), player.getName());
    }

    public VotingPluginUser getVotingPluginUser(String playerName) {
        return new VotingPluginUser(this.plugin, this.plugin.getUserManager().getProperName(playerName));
    }

    public VotingPluginUser getVotingPluginUser(UUID uuid) {
        return new VotingPluginUser(this.plugin, uuid);
    }

    public VotingPluginUser getVotingPluginUser(UUID uuid, boolean loadName) {
        return new VotingPluginUser(this.plugin, uuid, loadName);
    }

    public VotingPluginUser getVotingPluginUser(UUID uuid, String playerName) {
        return new VotingPluginUser(this.plugin, uuid, playerName);
    }

    public void purgeOldPlayersNoData() {
        if (this.plugin.getOptions().isPurgeOldData() && this.plugin.getConfigFile().isPurgeNoDataOnStartup()) {
            this.plugin.addUserStartup(new UserStartup(){

                @Override
                public void onFinish() {
                    UserManager.this.plugin.debug("Finished no data purging");
                }

                @Override
                public void onStart() {
                }

                @Override
                public void onStartUp(AdvancedCoreUser acUser) {
                    VotingPluginUser user = UserManager.this.getVotingPluginUser(acUser);
                    user.dontCache();
                    int daysOld = UserManager.this.plugin.getOptions().getPurgeMinimumDays();
                    int days = user.getNumberOfDaysSinceLogin();
                    if (days == -1) {
                        user.setLastOnline(System.currentTimeMillis());
                    } else if (days > daysOld && user.getTotal(TopVoter.AllTime) == 0 && user.getMilestoneCount() == 0 && user.getTotal(TopVoter.Monthly) == 0 && user.getTotal(TopVoter.Weekly) == 0 && user.getTotal(TopVoter.Daily) == 0) {
                        UserManager.this.plugin.debug("Removing " + user.getUUID() + " because of no data purge");
                        user.remove();
                    }
                }
            });
        }
        this.plugin.getUserManager().getDataManager().clearCache();
    }

    public void purgeOldPlayersNowNoData() {
        HashMap<UUID, ArrayList<Column>> cols = this.plugin.getUserManager().getAllKeys();
        for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
            VotingPluginUser user;
            String uuid = playerData.getKey().toString();
            if (!this.plugin.isEnabled() || uuid == null || (user = this.getVotingPluginUser(UUID.fromString(uuid), false)) == null) continue;
            user.dontCache();
            user.updateTempCacheWithColumns(playerData.getValue());
            int daysOld = this.plugin.getOptions().getPurgeMinimumDays();
            int days = user.getNumberOfDaysSinceLogin();
            if (days == -1) {
                user.setLastOnline(System.currentTimeMillis());
            } else if (days > daysOld) {
                if (user.getTotal(TopVoter.AllTime) == 0 && user.getMilestoneCount() == 0 && user.getTotal(TopVoter.Monthly) == 0 && user.getTotal(TopVoter.Weekly) == 0 && user.getTotal(TopVoter.Daily) == 0) {
                    this.plugin.debug("Removing " + user.getUUID() + " because of no data purge");
                }
                user.remove();
            }
            user.clearTempCache();
            cols.put(playerData.getKey(), null);
            user = null;
        }
        cols.clear();
        cols = null;
        this.plugin.getUserManager().getDataManager().clearCache();
        this.plugin.setUpdate(true);
    }
}

