/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.updater;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.simpleapi.updater.Updater;
import java.util.Timer;
import java.util.TimerTask;
import org.bukkit.plugin.Plugin;

public class CheckUpdate {
    private VotingPluginMain plugin;

    public CheckUpdate(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public void checkUpdate() {
        if (this.plugin.getConfigFile().isDisableUpdateChecking() || this.plugin.getDescription().getVersion().endsWith("SNAPSHOT")) {
            return;
        }
        this.plugin.setUpdater(new Updater(this.plugin, 15358, false));
        Updater.UpdateResult result = this.plugin.getUpdater().getResult();
        switch (result) {
            case FAIL_SPIGOT: {
                this.plugin.getLogger().info("Failed to check for update for " + this.plugin.getName() + "!");
                break;
            }
            case NO_UPDATE: {
                this.plugin.getLogger().info(this.plugin.getName() + " is up to date! Version: " + this.plugin.getUpdater().getVersion());
                break;
            }
            case UPDATE_AVAILABLE: {
                this.plugin.getLogger().info(this.plugin.getName() + " has an update available! Your Version: " + this.plugin.getDescription().getVersion() + " New Version: " + this.plugin.getUpdater().getVersion());
                break;
            }
        }
    }

    public void checkUpdateBasic() {
        if (this.plugin.getConfigFile().isDisableUpdateChecking()) {
            return;
        }
        this.plugin.setUpdater(new Updater(this.plugin, 15358, false));
        Updater.UpdateResult result = this.plugin.getUpdater().getResult();
        switch (result) {
            case UPDATE_AVAILABLE: {
                this.plugin.getLogger().info(this.plugin.getName() + " has an update available! Your Version: " + this.plugin.getDescription().getVersion() + " New Version: " + this.plugin.getUpdater().getVersion());
                break;
            }
        }
    }

    public void startUp() {
        if (this.plugin.getConfigFile().isDisableUpdateChecking() || this.plugin.getDescription().getVersion().endsWith("SNAPSHOT")) {
            return;
        }
        this.plugin.getBukkitScheduler().runTaskLaterAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                CheckUpdate.this.checkUpdate();
                new Timer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        CheckUpdate.this.checkUpdateBasic();
                    }
                }, 72000000L, 72000000L);
            }
        }, 10L);
    }
}

