/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.topvoter;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import com.bencodez.votingplugin.advancedcore.api.time.events.DateChangedEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.DayChangeEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.MonthChangeEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.PreDateChangedEvent;
import com.bencodez.votingplugin.advancedcore.api.time.events.WeekChangeEvent;
import com.bencodez.votingplugin.advancedcore.api.user.UserStorage;
import com.bencodez.votingplugin.simpleapi.array.ArrayUtils;
import com.bencodez.votingplugin.simpleapi.file.YMLFileHandler;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.simpleapi.sql.Column;
import com.bencodez.votingplugin.simpleapi.sql.DataType;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.topvoter.TopVoterPlayer;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.io.File;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TopVoterHandler
implements Listener {
    private VotingPluginMain plugin;

    public TopVoterHandler(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public boolean bungeeHandleResets() {
        return this.plugin.getBungeeSettings().isUseBungeecoord() && this.plugin.getBungeeSettings().isGloblalDataEnabled();
    }

    public String getGottenMilestonesPath() {
        if (this.plugin.getBungeeSettings().isPerServerMilestones()) {
            return this.plugin.getBungeeSettings().getServerNameStorage() + "_GottenMilestones";
        }
        return "GottenMileStones";
    }

    public LinkedHashMap<TopVoterPlayer, Integer> getMonthlyTopVotersAtTime(LocalDateTime atTime) {
        HashMap<UUID, ArrayList<Column>> cols = this.plugin.getUserManager().getAllKeys();
        LinkedHashMap<TopVoterPlayer, Integer> topVoter = new LinkedHashMap<TopVoterPlayer, Integer>();
        for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
            String uuid = playerData.getKey().toString();
            if (this.plugin == null || !this.plugin.isEnabled() || uuid == null || uuid.isEmpty()) continue;
            VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), false);
            user.dontCache();
            user.updateTempCacheWithColumns(playerData.getValue());
            cols.put(playerData.getKey(), null);
            int total = user.getTotal(TopVoter.Monthly, atTime);
            if (total <= 0) continue;
            topVoter.put(user.getTopVoterPlayer(), total);
        }
        return this.sortByValues(topVoter, false);
    }

    public ArrayList<String> getTopVoterBlackList() {
        return this.plugin.getConfigFile().getBlackList();
    }

    public LinkedHashMap<TopVoterPlayer, Integer> getTopVotersOfMonth(YearMonth month, HashMap<UUID, ArrayList<Column>> cols) {
        LinkedHashMap<TopVoterPlayer, Integer> totals = new LinkedHashMap<TopVoterPlayer, Integer>();
        LocalDateTime atTime = month.atDay(15).atTime(0, 0);
        for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
            String uuid = playerData.getKey().toString();
            if (uuid == null || uuid.isEmpty()) continue;
            VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), false);
            user.dontCache();
            user.updateTempCacheWithColumns(playerData.getValue());
            int total = 0;
            total = user.getTotal(TopVoter.Monthly, atTime);
            if (total > 0) {
                totals.put(user.getTopVoterPlayer(), total);
            }
            user.clearTempCache();
        }
        return this.sortByValues(totals, false);
    }

    public String[] getTopVotersWeekly() {
        ArrayList<String> msg = new ArrayList<String>();
        ArrayList<TopVoterPlayer> users = this.plugin.convertSet(this.plugin.getTopVoter(TopVoter.Weekly).keySet());
        for (int i = 0; i < users.size(); ++i) {
            String line = this.plugin.getConfigFile().getFormatCommandsVoteTopLine().replace("%num%", "" + (i + 1)).replace("%player%", users.get(i).getPlayerName()).replace("%votes%", "" + this.plugin.getTopVoter(TopVoter.Weekly).get(users.get(i)));
            msg.add(line);
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    private HashMap<Integer, String> handlePlaces(Set<String> places) {
        HashMap<Integer, String> place = new HashMap<Integer, String>();
        for (String p : places) {
            String[] data = p.split("-");
            try {
                if (data.length > 1) {
                    for (int i = Integer.parseInt(data[0]); i < Integer.parseInt(data[1]); ++i) {
                        place.put(i, p);
                    }
                    continue;
                }
                place.put(Integer.parseInt(data[0]), p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return place;
    }

    public void loadLastMonth() {
        if (this.plugin.getGui().isLastMonthGUI()) {
            this.plugin.getLastMonthTopVoter().clear();
            LinkedHashMap<TopVoterPlayer, Integer> totals = new LinkedHashMap<TopVoterPlayer, Integer>();
            HashMap<UUID, ArrayList<Column>> cols = this.plugin.getUserManager().getAllKeys();
            LocalDateTime lastMonthTime = this.plugin.getTimeChecker().getTime().minusMonths(1L);
            for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
                String uuid = playerData.getKey().toString();
                if (this.plugin == null || !this.plugin.isEnabled() || uuid == null || uuid.isEmpty()) continue;
                VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), false);
                user.dontCache();
                user.updateTempCacheWithColumns(playerData.getValue());
                cols.put(playerData.getKey(), null);
                int total = 0;
                total = this.plugin.getConfigFile().isUseMonthDateTotalsAsPrimaryTotal() ? user.getTotal(TopVoter.Monthly, lastMonthTime) : user.getLastMonthTotal();
                if (total > 0) {
                    totals.put(user.getTopVoterPlayer(), total);
                }
                user.clearTempCache();
            }
            cols.clear();
            cols = null;
            this.plugin.getLastMonthTopVoter().putAll(this.sortByValues(totals, false));
            this.plugin.debug("Loaded last month top voters");
        }
    }

    public void loadPreviousMonthTopVoters() {
        if (this.plugin.getConfigFile().isStoreMonthTotalsWithDate()) {
            LocalDateTime now = this.plugin.getTimeChecker().getTime();
            for (String string : this.plugin.getUserManager().getAllColumns()) {
                YearMonth yearMonth;
                String[] stringArray;
                if (!string.startsWith("MonthTotal-") || (stringArray = string.split("-")).length <= 2) continue;
                String year = stringArray[2];
                String month = stringArray[1];
                if (!MessageAPI.isInt(year) || !(yearMonth = YearMonth.of(Integer.parseInt(year), Month.valueOf(month))).isBefore(YearMonth.of(now.getYear(), now.getMonth()))) continue;
                this.plugin.debug("Loading previous month top voters of " + yearMonth.toString());
                this.plugin.getPreviousMonthsTopVoters().put(yearMonth, new LinkedHashMap());
            }
            if (this.plugin.getPreviousMonthsTopVoters().size() > 0) {
                HashMap<UUID, ArrayList<Column>> cols = this.plugin.getUserManager().getAllKeys();
                for (Map.Entry<UUID, ArrayList<Column>> entry : cols.entrySet()) {
                    String uuid = entry.getKey().toString();
                    if (uuid == null || uuid.isEmpty()) continue;
                    VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(UUID.fromString(uuid), false);
                    user.dontCache();
                    user.updateTempCacheWithColumns(entry.getValue());
                    for (YearMonth month : this.plugin.getPreviousMonthsTopVoters().keySet()) {
                        LocalDateTime atTime = month.atDay(15).atTime(0, 0);
                        int total = user.getTotal(TopVoter.Monthly, atTime);
                        if (total <= 0) continue;
                        this.plugin.getPreviousMonthsTopVoters().get(month).put(user.getTopVoterPlayer(), total);
                    }
                    cols.put(entry.getKey(), null);
                    user.clearTempCache();
                }
                cols.clear();
                Iterator<Object> iterator = null;
            }
            for (YearMonth yearMonth : this.plugin.getPreviousMonthsTopVoters().keySet()) {
                this.plugin.getPreviousMonthsTopVoters().put(yearMonth, this.sortByValues(this.plugin.getPreviousMonthsTopVoters().get(yearMonth), false));
            }
            this.plugin.extraDebug("Previous Months: " + this.plugin.getPreviousMonthsTopVoters().keySet().toString());
            for (Map.Entry entry : this.plugin.getPreviousMonthsTopVoters().entrySet()) {
                for (Map.Entry entry2 : ((LinkedHashMap)entry.getValue()).entrySet()) {
                    this.plugin.extraDebug(((YearMonth)entry.getKey()).toString() + ": " + ((TopVoterPlayer)entry2.getKey()).getUser().getPlayerName() + ":" + (Integer)entry2.getValue());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onDateChanged(DateChangedEvent event) {
        this.plugin.setUpdate(true);
        this.plugin.update();
        if (event.getTimeType().equals((Object)TimeType.MONTH)) {
            this.loadLastMonth();
        }
        if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
            this.plugin.getMysql().clearCacheBasic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDayChange(DayChangeEvent event) {
        VotingPluginMain votingPluginMain = VotingPluginMain.plugin;
        synchronized (votingPluginMain) {
            long startTime = System.currentTimeMillis();
            if (this.plugin.getConfigFile().isStoreTopVotersDaily()) {
                this.plugin.getLogger().info("Saving TopVoters Daily");
                this.storeTopVoters(TopVoter.Daily);
            }
            this.plugin.getUserManager().copyColumnData(TopVoter.Daily.getColumnName(), TopVoter.Daily.getLastColumnName());
            if (this.plugin.getConfigFile().isUseVoteStreaks() || this.plugin.getConfigFile().isUseHighestTotals()) {
                HashMap<UUID, ArrayList<Column>> cols = this.plugin.getUserManager().getAllKeys();
                for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
                    VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(playerData.getKey(), false);
                    user.dontCache();
                    user.updateTempCacheWithColumns(playerData.getValue());
                    cols.put(playerData.getKey(), null);
                    if (this.plugin.getConfigFile().isUseVoteStreaks() && !user.voteStreakUpdatedToday(LocalDateTime.now().minusDays(1L)) && user.getDayVoteStreak() != 0) {
                        user.setDayVoteStreak(0);
                    }
                    if (this.plugin.getConfigFile().isUseHighestTotals() && user.getHighestDailyTotal() < user.getTotal(TopVoter.Daily)) {
                        user.setHighestDailyTotal(user.getTotal(TopVoter.Daily));
                    }
                    user.clearTempCache();
                }
                cols.clear();
                cols = null;
            }
            try {
                if (this.plugin.getSpecialRewardsConfig().isEnableDailyRewards()) {
                    HashMap<Integer, String> places = this.handlePlaces(this.plugin.getSpecialRewardsConfig().getDailyPossibleRewardPlaces());
                    int i = 0;
                    int lastTotal = -1;
                    LinkedHashMap clone = (LinkedHashMap)this.plugin.getTopVoter(TopVoter.Daily).clone();
                    for (Map.Entry entry : clone.entrySet()) {
                        if (this.plugin.getConfigFile().isTopVoterAwardsTies()) {
                            if ((Integer)entry.getValue() != lastTotal) {
                                ++i;
                            }
                        } else {
                            ++i;
                        }
                        if (places.containsKey(i)) {
                            VotingPluginUser user = ((TopVoterPlayer)entry.getKey()).getUser();
                            user.dontCache();
                            if (!this.plugin.getConfigFile().isTopVoterIgnorePermission() || !user.isTopVoterIgnore()) {
                                user.giveDailyTopVoterAward(i, places.get(i));
                                this.plugin.getLogger().info("Giving daily top voter reward " + i + " to " + ((TopVoterPlayer)entry.getKey()).getPlayerName());
                            }
                        }
                        lastTotal = (Integer)entry.getValue();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (String shopIdent : this.plugin.getShopFile().getShopIdentifiers()) {
                if (!this.plugin.getShopFile().getVoteShopResetDaily(shopIdent)) continue;
                this.resetVoteShopLimit(shopIdent);
            }
            if (!this.plugin.getTopVoterHandler().bungeeHandleResets() && this.plugin.getBungeeSettings().isUseBungeecoord()) {
                this.plugin.debug("Delaying time change 10 seconds for other servers to catchup");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!this.bungeeHandleResets()) {
                this.resetTotals(TopVoter.Daily);
            }
            if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
                this.plugin.getMysql().clearCacheBasic();
            }
            long now = (System.currentTimeMillis() - startTime) / 1000L;
            this.plugin.getLogger().info("Finished processing day change, took " + now + " seconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMonthChange(MonthChangeEvent event) {
        long startTime = System.currentTimeMillis();
        VotingPluginMain votingPluginMain = VotingPluginMain.plugin;
        synchronized (votingPluginMain) {
            this.plugin.getLogger().info("Saving TopVoters Monthly");
            this.storeTopVoters(TopVoter.Monthly);
            if (!this.bungeeHandleResets()) {
                this.plugin.getUserManager().copyColumnData(TopVoter.Monthly.getColumnName(), TopVoter.Monthly.getLastColumnName());
            }
            LocalDateTime lastMonthTime = this.plugin.getTimeChecker().getTime().minusMonths(1L);
            if (this.plugin.getConfigFile().isUseHighestTotals() || this.plugin.getConfigFile().isUseVoteStreaks()) {
                HashMap<UUID, ArrayList<Column>> cols = this.plugin.getUserManager().getAllKeys();
                for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
                    VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(playerData.getKey(), false);
                    user.dontCache();
                    user.updateTempCacheWithColumns(playerData.getValue());
                    cols.put(playerData.getKey(), null);
                    if (this.plugin.getConfigFile().isUseVoteStreaks()) {
                        if (user.getTotal(TopVoter.Monthly, lastMonthTime) == 0 && user.getMonthVoteStreak() != 0) {
                            user.setMonthVoteStreak(0);
                        } else if (!this.plugin.getSpecialRewardsConfig().isVoteStreakRequirementUsePercentage() || user.hasPercentageTotal(TopVoter.Monthly, this.plugin.getSpecialRewardsConfig().getVoteStreakRequirementMonth(), lastMonthTime)) {
                            user.addMonthVoteStreak();
                            this.plugin.getSpecialRewards().checkVoteStreak(user, "Month", this.plugin.getBungeeSettings().isUseBungeecoord());
                        }
                    }
                    if (this.plugin.getConfigFile().isUseHighestTotals() && user.getHighestMonthlyTotal() < user.getTotal(TopVoter.Monthly, lastMonthTime)) {
                        user.setHighestMonthlyTotal(user.getTotal(TopVoter.Monthly, lastMonthTime));
                    }
                    user.clearTempCache();
                }
                cols.clear();
                cols = null;
            }
            try {
                if (this.plugin.getSpecialRewardsConfig().isEnableMonthlyAwards()) {
                    LinkedHashMap clone;
                    HashMap<Integer, String> places = this.handlePlaces(this.plugin.getSpecialRewardsConfig().getMonthlyPossibleRewardPlaces());
                    int i = 0;
                    int lastTotal = -1;
                    LinkedHashMap topVoters = null;
                    topVoters = this.plugin.getConfigFile().isUseMonthDateTotalsAsPrimaryTotal() ? this.getMonthlyTopVotersAtTime(lastMonthTime) : (clone = (LinkedHashMap)this.plugin.getTopVoter(TopVoter.Monthly).clone());
                    for (Map.Entry<TopVoterPlayer, Integer> entry : topVoters.entrySet()) {
                        if (this.plugin.getConfigFile().isTopVoterAwardsTies()) {
                            if (entry.getValue() != lastTotal) {
                                ++i;
                            }
                        } else {
                            ++i;
                        }
                        if (places.containsKey(i)) {
                            VotingPluginUser user = entry.getKey().getUser();
                            user.dontCache();
                            if (!this.plugin.getConfigFile().isTopVoterIgnorePermission() || !user.isTopVoterIgnore()) {
                                user.giveMonthlyTopVoterAward(i, places.get(i));
                                this.plugin.getLogger().info("Giving Monthly top voter reward " + i + " to " + entry.getKey().getPlayerName());
                            }
                        }
                        lastTotal = entry.getValue();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.plugin.getSpecialRewardsConfig().isResetMilestonesMonthly()) {
                this.resetMilestoneCount();
                this.resetGottenMilestones();
            }
            for (String shopIdent : this.plugin.getShopFile().getShopIdentifiers()) {
                if (!this.plugin.getShopFile().getVoteShopResetMonthly(shopIdent)) continue;
                this.resetVoteShopLimit(shopIdent);
            }
            if (!this.bungeeHandleResets() && this.plugin.getBungeeSettings().isUseBungeecoord()) {
                this.plugin.debug("Delaying time change 10 seconds for other servers to catchup");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!this.bungeeHandleResets()) {
                this.resetTotals(TopVoter.Monthly);
            }
            if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
                this.plugin.getMysql().clearCacheBasic();
            }
            long now = (System.currentTimeMillis() - startTime) / 1000L;
            this.plugin.getLogger().info("Finished processing day change, took " + now + " seconds");
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPreDateChanged(PreDateChangedEvent event) {
        if (event.getTimeType().equals((Object)TimeType.DAY)) {
            this.plugin.getBannedPlayers().clear();
            for (OfflinePlayer p : Bukkit.getBannedPlayers()) {
                this.plugin.getBannedPlayers().add(p.getUniqueId().toString());
            }
        }
        this.plugin.setUpdate(true);
        this.plugin.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWeekChange(WeekChangeEvent event) {
        long startTime = System.currentTimeMillis();
        VotingPluginMain votingPluginMain = VotingPluginMain.plugin;
        synchronized (votingPluginMain) {
            if (this.plugin.getConfigFile().isStoreTopVotersWeekly()) {
                this.plugin.getLogger().info("Saving TopVoters Weekly");
                this.storeTopVoters(TopVoter.Weekly);
            }
            this.plugin.getUserManager().copyColumnData(TopVoter.Weekly.getColumnName(), TopVoter.Weekly.getLastColumnName());
            if (this.plugin.getConfigFile().isUseVoteStreaks() || this.plugin.getConfigFile().isUseHighestTotals()) {
                HashMap<UUID, ArrayList<Column>> cols = this.plugin.getUserManager().getAllKeys();
                for (Map.Entry<UUID, ArrayList<Column>> playerData : cols.entrySet()) {
                    VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(playerData.getKey(), false);
                    user.dontCache();
                    user.updateTempCacheWithColumns(playerData.getValue());
                    cols.put(playerData.getKey(), null);
                    if (this.plugin.getConfigFile().isUseVoteStreaks()) {
                        if (user.getTotal(TopVoter.Weekly) == 0 && user.getWeekVoteStreak() != 0) {
                            user.setWeekVoteStreak(0);
                        } else if (!this.plugin.getSpecialRewardsConfig().isVoteStreakRequirementUsePercentage() || user.hasPercentageTotal(TopVoter.Weekly, this.plugin.getSpecialRewardsConfig().getVoteStreakRequirementWeek(), null)) {
                            user.addWeekVoteStreak();
                            this.plugin.getSpecialRewards().checkVoteStreak(user, "Week", this.plugin.getBungeeSettings().isUseBungeecoord());
                        }
                    }
                    if (this.plugin.getConfigFile().isUseHighestTotals() && user.getHighestWeeklyTotal() < user.getTotal(TopVoter.Weekly)) {
                        user.setHighestWeeklyTotal(user.getTotal(TopVoter.Weekly));
                    }
                    user.clearTempCache();
                }
                cols.clear();
                cols = null;
            }
            try {
                if (this.plugin.getSpecialRewardsConfig().isEnableWeeklyAwards()) {
                    HashMap<Integer, String> places = this.handlePlaces(this.plugin.getSpecialRewardsConfig().getWeeklyPossibleRewardPlaces());
                    int i = 0;
                    int lastTotal = -1;
                    LinkedHashMap clone = (LinkedHashMap)this.plugin.getTopVoter(TopVoter.Weekly).clone();
                    for (Map.Entry entry : clone.entrySet()) {
                        if (this.plugin.getConfigFile().isTopVoterAwardsTies()) {
                            if ((Integer)entry.getValue() != lastTotal) {
                                ++i;
                            }
                        } else {
                            ++i;
                        }
                        if (places.containsKey(i)) {
                            VotingPluginUser user = ((TopVoterPlayer)entry.getKey()).getUser();
                            user.dontCache();
                            if (!this.plugin.getConfigFile().isTopVoterIgnorePermission() || !user.isTopVoterIgnore()) {
                                user.giveWeeklyTopVoterAward(i, places.get(i));
                                this.plugin.getLogger().info("Giving weekly top voter reward " + i + " to " + ((TopVoterPlayer)entry.getKey()).getPlayerName());
                            }
                        }
                        lastTotal = (Integer)entry.getValue();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (String shopIdent : this.plugin.getShopFile().getShopIdentifiers()) {
                if (!this.plugin.getShopFile().getVoteShopResetWeekly(shopIdent)) continue;
                this.resetVoteShopLimit(shopIdent);
            }
            if (!this.plugin.getTopVoterHandler().bungeeHandleResets() && this.plugin.getBungeeSettings().isUseBungeecoord()) {
                this.plugin.debug("Delaying time change 10 seconds for other servers to catchup");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!this.bungeeHandleResets()) {
                this.resetTotals(TopVoter.Weekly);
            }
            if (this.plugin.getStorageType().equals((Object)UserStorage.MYSQL)) {
                this.plugin.getMysql().clearCacheBasic();
            }
            long now = (System.currentTimeMillis() - startTime) / 1000L;
            this.plugin.getLogger().info("Finished processing day change, took " + now + " seconds");
        }
    }

    public void register() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void resetGottenMilestones() {
        this.plugin.getUserManager().removeAllKeyValues(this.getGottenMilestonesPath(), DataType.STRING);
    }

    public void resetMilestoneCount() {
        this.plugin.getUserManager().removeAllKeyValues("MilestoneCount", DataType.INTEGER);
    }

    public void resetTotals(TopVoter topVoter) {
        this.plugin.getUserManager().removeAllKeyValues(topVoter.getColumnName(), DataType.INTEGER);
    }

    public void resetVoteShopLimit(String shopIdent) {
        this.plugin.getUserManager().removeAllKeyValues("VoteShopLimit" + shopIdent, DataType.INTEGER);
    }

    public LinkedHashMap<TopVoterPlayer, Integer> sortByValues(LinkedHashMap<TopVoterPlayer, Integer> map, final boolean order) {
        LinkedList<Map.Entry<TopVoterPlayer, Integer>> list = new LinkedList<Map.Entry<TopVoterPlayer, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<TopVoterPlayer, Integer>>(){

            @Override
            public int compare(Map.Entry<TopVoterPlayer, Integer> o1, Map.Entry<TopVoterPlayer, Integer> o2) {
                if (order) {
                    int result = o1.getValue().compareTo(o2.getValue());
                    if (result != 0) {
                        return result;
                    }
                    return o2.getKey().getLastVoteTime().compareTo(o1.getKey().getLastVoteTime());
                }
                int result = o2.getValue().compareTo(o1.getValue());
                if (result != 0) {
                    return result;
                }
                return o1.getKey().getLastVoteTime().compareTo(o2.getKey().getLastVoteTime());
            }
        });
        LinkedHashMap<TopVoterPlayer, Integer> sortedMap = new LinkedHashMap<TopVoterPlayer, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((TopVoterPlayer)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    public void storeTopVoters(TopVoter top) {
        LocalDateTime time = LocalDateTime.now().minusDays(1L);
        String month = time.getMonth().toString();
        int year = time.getYear();
        int week = time.getDayOfYear();
        int day = time.getDayOfMonth();
        String fileName = "TopVoter" + File.separator + top.toString() + File.separator + year + "_" + month;
        if (top.equals((Object)TopVoter.Daily)) {
            fileName = fileName + "_" + day;
        } else if (top.equals((Object)TopVoter.Weekly)) {
            fileName = fileName + "_" + week;
        }
        fileName = fileName + "_" + System.currentTimeMillis() + ".yml";
        YMLFileHandler file = new YMLFileHandler(this.plugin, new File(this.plugin.getDataFolder(), fileName));
        file.setup();
        file.header("Saving top voters for " + top.toString() + ", file also contains other top voter info as backup");
        for (TopVoter cTop : TopVoter.values()) {
            ArrayList<String> topVoters = new ArrayList<String>();
            int cTotal = 0;
            try {
                ArrayList<Integer> nums = this.plugin.getUserManager().getNumbersInColumn(cTop.getColumnName());
                for (Integer n : nums) {
                    cTotal += n.intValue();
                }
                topVoters.add("Combined total: " + cTotal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.plugin.getTopVoter().containsKey((Object)cTop)) continue;
            int count = 1;
            for (Map.Entry entry : this.plugin.getTopVoter(cTop).entrySet()) {
                topVoters.add(count + ": " + ((TopVoterPlayer)entry.getKey()).getPlayerName() + ": " + entry.getValue());
                ++count;
            }
            file.getData().set(cTop.toString(), topVoters);
        }
        file.saveData();
    }

    public String[] topVoterAllTime(int page) {
        int pagesize = this.plugin.getConfigFile().getFormatPageSize();
        ArrayList<String> msg = new ArrayList<String>();
        ArrayList<String> topVoters = new ArrayList<String>();
        int count = 1;
        for (Map.Entry<TopVoterPlayer, Integer> entry : this.plugin.getTopVoter(TopVoter.AllTime).entrySet()) {
            String line = this.plugin.getConfigFile().getFormatCommandsVoteTopLine();
            line = line.replace("%num%", "" + count);
            line = line.replace("%player%", entry.getKey().getPlayerName());
            line = line.replace("%votes%", "" + entry.getValue());
            topVoters.add(line);
            ++count;
        }
        int pageSize = topVoters.size() / pagesize;
        if (topVoters.size() % pagesize != 0) {
            ++pageSize;
        }
        String title = this.plugin.getConfigFile().getFormatCommandVoteTopTitle();
        title = title.replace("%page%", "" + page);
        title = title.replace("%maxpages%", "" + pageSize);
        title = title.replace("%Top%", this.plugin.getConfigFile().getFormatTopVoterAllTime());
        msg.add(MessageAPI.colorize(title));
        for (int i = (page - 1) * pagesize; i < topVoters.size() && i < (page - 1) * pagesize + 10; ++i) {
            msg.add((String)topVoters.get(i));
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    public String[] topVoterDaily(int page) {
        int pagesize = this.plugin.getConfigFile().getFormatPageSize();
        ArrayList<String> msg = new ArrayList<String>();
        ArrayList<String> topVoters = new ArrayList<String>();
        int count = 1;
        for (Map.Entry<TopVoterPlayer, Integer> entry : this.plugin.getTopVoter(TopVoter.Daily).entrySet()) {
            String line = this.plugin.getConfigFile().getFormatCommandsVoteTopLine();
            line = line.replace("%num%", "" + count);
            line = line.replace("%player%", entry.getKey().getPlayerName());
            line = line.replace("%votes%", "" + entry.getValue());
            topVoters.add(line);
            ++count;
        }
        int pageSize = topVoters.size() / pagesize;
        if (topVoters.size() % pagesize != 0) {
            ++pageSize;
        }
        String title = this.plugin.getConfigFile().getFormatCommandVoteTopTitle();
        title = title.replace("%page%", "" + page);
        title = title.replace("%maxpages%", "" + pageSize);
        title = title.replace("%Top%", this.plugin.getConfigFile().getFormatTopVoterDaily());
        msg.add(MessageAPI.colorize(title));
        for (int i = (page - 1) * pagesize; i < topVoters.size() && i < (page - 1) * pagesize + 10; ++i) {
            msg.add((String)topVoters.get(i));
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    public String[] topVoterMonthly(int page) {
        int pagesize = this.plugin.getConfigFile().getFormatPageSize();
        ArrayList<String> msg = new ArrayList<String>();
        ArrayList<String> topVoters = new ArrayList<String>();
        int count = 1;
        for (Map.Entry<TopVoterPlayer, Integer> entry : this.plugin.getTopVoter(TopVoter.Monthly).entrySet()) {
            String line = this.plugin.getConfigFile().getFormatCommandsVoteTopLine();
            line = line.replace("%num%", "" + count);
            line = line.replace("%player%", entry.getKey().getPlayerName());
            line = line.replace("%votes%", "" + entry.getValue());
            topVoters.add(line);
            ++count;
        }
        int pageSize = topVoters.size() / pagesize;
        if (topVoters.size() % pagesize != 0) {
            ++pageSize;
        }
        String title = this.plugin.getConfigFile().getFormatCommandVoteTopTitle();
        title = title.replace("%page%", "" + page);
        title = title.replace("%maxpages%", "" + pageSize);
        title = title.replace("%Top%", this.plugin.getConfigFile().getFormatTopVoterMonthly());
        msg.add(MessageAPI.colorize(title));
        for (int i = (page - 1) * pagesize; i < topVoters.size() && i < (page - 1) * pagesize + 10; ++i) {
            msg.add((String)topVoters.get(i));
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    public String[] topVotersAllTime() {
        ArrayList<String> msg = new ArrayList<String>();
        LinkedList<Map.Entry<TopVoterPlayer, Integer>> list = new LinkedList<Map.Entry<TopVoterPlayer, Integer>>(this.plugin.getTopVoter(TopVoter.AllTime).entrySet());
        int i = 0;
        for (Map.Entry entry : list) {
            String line = "%num%: %player%, %votes%";
            line = line.replace("%num%", "" + (i + 1));
            try {
                line = line.replace("%player%", ((TopVoterPlayer)entry.getKey()).getPlayerName());
            }
            catch (Exception ex) {
                VotingPluginMain.plugin.debug(ex);
            }
            line = line.replace("%votes%", "" + entry.getValue());
            msg.add(line);
            ++i;
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    public String[] topVotersDaily() {
        ArrayList<String> msg = new ArrayList<String>();
        ArrayList<TopVoterPlayer> users = this.plugin.convertSet(this.plugin.getTopVoter(TopVoter.Daily).keySet());
        for (int i = 0; i < users.size(); ++i) {
            String line = "%num%: %player%, %votes%";
            line = line.replace("%num%", "" + (i + 1));
            try {
                line = line.replace("%player%", users.get(i).getPlayerName());
            }
            catch (Exception ex) {
                VotingPluginMain.plugin.debug(ex);
            }
            line = line.replace("%votes%", "" + this.plugin.getTopVoter(TopVoter.Monthly).get(users.get(i)));
            msg.add(line);
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    public String[] topVotersMonthly() {
        ArrayList<String> msg = new ArrayList<String>();
        LinkedList<Map.Entry<TopVoterPlayer, Integer>> list = new LinkedList<Map.Entry<TopVoterPlayer, Integer>>(this.plugin.getTopVoter(TopVoter.Monthly).entrySet());
        int i = 0;
        for (Map.Entry entry : list) {
            String line = "%num%: %player%, %votes%";
            line = line.replace("%num%", "" + (i + 1));
            try {
                line = line.replace("%player%", ((TopVoterPlayer)entry.getKey()).getPlayerName());
            }
            catch (Exception ex) {
                VotingPluginMain.plugin.debug(ex);
            }
            line = line.replace("%votes%", "" + entry.getValue());
            msg.add(line);
            ++i;
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    public String[] topVoterWeekly(int page) {
        int pagesize = this.plugin.getConfigFile().getFormatPageSize();
        ArrayList<String> msg = new ArrayList<String>();
        ArrayList<String> topVoters = new ArrayList<String>();
        int count = 1;
        for (Map.Entry<TopVoterPlayer, Integer> entry : this.plugin.getTopVoter(TopVoter.Weekly).entrySet()) {
            String line = this.plugin.getConfigFile().getFormatCommandsVoteTopLine();
            line = line.replace("%num%", "" + count);
            line = line.replace("%player%", entry.getKey().getPlayerName());
            line = line.replace("%votes%", "" + entry.getValue());
            topVoters.add(line);
            ++count;
        }
        int pageSize = topVoters.size() / pagesize;
        if (topVoters.size() % pagesize != 0) {
            ++pageSize;
        }
        String title = this.plugin.getConfigFile().getFormatCommandVoteTopTitle();
        title = title.replace("%page%", "" + page);
        title = title.replace("%maxpages%", "" + pageSize);
        title = title.replace("%Top%", this.plugin.getConfigFile().getFormatTopVoterWeekly());
        msg.add(MessageAPI.colorize(title));
        for (int i = (page - 1) * pagesize; i < topVoters.size() && i < (page - 1) * pagesize + 10; ++i) {
            msg.add((String)topVoters.get(i));
        }
        msg = ArrayUtils.colorize(msg);
        return ArrayUtils.convert(msg);
    }

    public synchronized void updateTopVoters(LinkedHashMap<TopVoter, LinkedHashMap<TopVoterPlayer, Integer>> tempTopVoter) {
        int limitSize = this.plugin.getConfigFile().getMaxiumNumberOfTopVotersToLoad();
        for (Map.Entry<TopVoter, LinkedHashMap<TopVoterPlayer, Integer>> entry : tempTopVoter.entrySet()) {
            ArrayList<TopVoterPlayer> listKeys;
            LinkedHashMap<TopVoterPlayer, Integer> map = entry.getValue();
            map = this.sortByValues(map, false);
            if (limitSize > 0 && (listKeys = new ArrayList<TopVoterPlayer>(map.keySet())).size() > limitSize) {
                for (int i = listKeys.size() - 1; i >= 0 && i >= limitSize; --i) {
                    map.remove(listKeys.get(i));
                }
            }
            tempTopVoter.put(entry.getKey(), map);
            this.plugin.setTopVoter(tempTopVoter);
            this.plugin.debug(entry.getKey().getName() + " TopVoter loaded, number of players " + map.size());
        }
        this.plugin.debug("Updated TopVoter");
    }
}

