/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.topvoter;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.time.TimeType;
import java.util.ArrayList;
import lombok.Generated;

public enum TopVoter {
    AllTime,
    Monthly,
    Weekly,
    Daily;

    private ArrayList<TopVoter> switchItems = new ArrayList();

    public static TopVoter getDefault() {
        TopVoter top = TopVoter.getTopVoter(VotingPluginMain.plugin.getConfigFile().getVoteTopDefault());
        if (top != null) {
            return top;
        }
        return AllTime;
    }

    public static TopVoter getTopVoter(String str) {
        for (TopVoter value : TopVoter.values()) {
            if (!value.toString().equalsIgnoreCase(str)) continue;
            return value;
        }
        return AllTime;
    }

    public static TopVoter of(TimeType type) {
        switch (type) {
            case DAY: {
                return Daily;
            }
            case MONTH: {
                return Monthly;
            }
            case WEEK: {
                return Weekly;
            }
        }
        return null;
    }

    public static TopVoter[] valuesMinusAllTime() {
        return new TopVoter[]{Daily, Weekly, Monthly};
    }

    public String getColumnName() {
        switch (this) {
            case AllTime: {
                return "AllTimeTotal";
            }
            case Daily: {
                return "DailyTotal";
            }
            case Monthly: {
                return "MonthTotal";
            }
            case Weekly: {
                return "WeeklyTotal";
            }
        }
        return null;
    }

    public String getLastColumnName() {
        switch (this) {
            case AllTime: {
                return null;
            }
            case Daily: {
                return "LastDailyTotal";
            }
            case Monthly: {
                return "LastMonthTotal";
            }
            case Weekly: {
                return "LastWeeklyTotal";
            }
        }
        return null;
    }

    public String getName() {
        if (this.equals((Object)Monthly)) {
            return VotingPluginMain.plugin.getConfigFile().getFormatTopVoterMonthly();
        }
        if (this.equals((Object)Weekly)) {
            return VotingPluginMain.plugin.getConfigFile().getFormatTopVoterWeekly();
        }
        if (this.equals((Object)Daily)) {
            return VotingPluginMain.plugin.getConfigFile().getFormatTopVoterDaily();
        }
        return VotingPluginMain.plugin.getConfigFile().getFormatTopVoterAllTime();
    }

    public TopVoter next() {
        ArrayList<TopVoter> list = new ArrayList<TopVoter>();
        if (this.switchItems != null && !this.switchItems.isEmpty()) {
            list.addAll(this.switchItems);
        } else {
            if (VotingPluginMain.plugin.getConfigFile().isLoadTopVoterAllTime()) {
                list.add(AllTime);
            }
            if (VotingPluginMain.plugin.getConfigFile().isLoadTopVoterMonthly()) {
                list.add(Monthly);
            }
            if (VotingPluginMain.plugin.getConfigFile().isLoadTopVoterWeekly()) {
                list.add(Weekly);
            }
            if (VotingPluginMain.plugin.getConfigFile().isLoadTopVoterDaily()) {
                list.add(Daily);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!((TopVoter)((Object)list.get(i))).equals((Object)this)) continue;
            int next = i + 1;
            if (next > list.size() - 1) {
                next = 0;
            }
            return (TopVoter)((Object)list.get(next));
        }
        return AllTime;
    }

    public TopVoter prev() {
        ArrayList<TopVoter> list = new ArrayList<TopVoter>();
        if (this.switchItems != null && !this.switchItems.isEmpty()) {
            list.addAll(this.switchItems);
        } else {
            if (VotingPluginMain.plugin.getConfigFile().isLoadTopVoterAllTime()) {
                list.add(AllTime);
            }
            if (VotingPluginMain.plugin.getConfigFile().isLoadTopVoterMonthly()) {
                list.add(Monthly);
            }
            if (VotingPluginMain.plugin.getConfigFile().isLoadTopVoterWeekly()) {
                list.add(Weekly);
            }
            if (VotingPluginMain.plugin.getConfigFile().isLoadTopVoterDaily()) {
                list.add(Daily);
            }
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!((TopVoter)((Object)list.get(i))).equals((Object)this)) continue;
            int prev = i - 1;
            if (prev < 0) {
                prev = list.size() - 1;
            }
            return (TopVoter)((Object)list.get(prev));
        }
        return AllTime;
    }

    @Generated
    public ArrayList<TopVoter> getSwitchItems() {
        return this.switchItems;
    }
}

