/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.timequeue;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.time.events.DateChangedEvent;
import com.bencodez.votingplugin.events.PlayerVoteEvent;
import com.bencodez.votingplugin.timequeue.VoteTimeQueue;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class TimeQueueHandler
implements Listener {
    private Queue<VoteTimeQueue> timeChangeQueue = new ConcurrentLinkedQueue<VoteTimeQueue>();
    private VotingPluginMain plugin;

    public TimeQueueHandler(VotingPluginMain plugin) {
        this.plugin = plugin;
        this.load();
    }

    public void addVote(String voteUsername, String voteSiteName) {
        this.timeChangeQueue.add(new VoteTimeQueue(voteUsername, voteSiteName, LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli()));
    }

    public void load() {
        for (String str : this.plugin.getServerData().getTimedVoteCacheKeys()) {
            ConfigurationSection data = this.plugin.getServerData().getTimedVoteCacheSection(str);
            this.timeChangeQueue.add(new VoteTimeQueue(data.getString("Name"), data.getString("Service"), data.getLong("Time")));
        }
        this.plugin.getServerData().clearTimedVoteCache();
        this.plugin.getVoteTimer().schedule(new Runnable(){

            @Override
            public void run() {
                TimeQueueHandler.this.processQueue();
            }
        }, 120L, TimeUnit.SECONDS);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void postTimeChange(DateChangedEvent event) {
        this.plugin.getVoteTimer().schedule(new Runnable(){

            @Override
            public void run() {
                TimeQueueHandler.this.processQueue();
            }
        }, 5L, TimeUnit.SECONDS);
    }

    public void processQueue() {
        while (this.getTimeChangeQueue().size() > 0) {
            VoteTimeQueue vote = this.getTimeChangeQueue().remove();
            PlayerVoteEvent voteEvent = new PlayerVoteEvent(this.plugin.getVoteSite(this.plugin.getVoteSiteName(true, vote.getService()), true), vote.getName(), vote.getService(), true);
            voteEvent.setTime(voteEvent.getTime());
            this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
            if (!voteEvent.isCancelled()) continue;
            this.plugin.debug("Vote cancelled");
            return;
        }
    }

    public void save() {
        if (!this.timeChangeQueue.isEmpty()) {
            int num = 0;
            for (VoteTimeQueue vote : this.timeChangeQueue) {
                this.plugin.getServerData().addTimeVoted(num, vote);
                ++num;
            }
        }
        this.timeChangeQueue.clear();
    }

    @Generated
    public Queue<VoteTimeQueue> getTimeChangeQueue() {
        return this.timeChangeQueue;
    }
}

