/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.test;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.rewards.Reward;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.events.PlayerVoteEvent;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class VoteTester {
    private VotingPluginMain plugin;

    public VoteTester(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public void generatePlayers(int numberOfPlayers) {
        if (this.plugin.getOptions().getDebug().isDebug()) {
            int num = 1;
            String salt = this.getSaltString();
            Random random = new Random();
            for (int i = 0; i < numberOfPlayers; ++i) {
                UUID uuid = UUID.randomUUID();
                if (this.plugin.getUserManager().userExist(uuid)) continue;
                String playerName = salt + num;
                if (this.plugin.getUserManager().userExist(playerName)) continue;
                VotingPluginUser user = this.plugin.getVotingPluginUserManager().getVotingPluginUser(uuid, playerName);
                user.dontCache();
                user.setPoints(random.nextInt(100));
                for (TopVoter top : TopVoter.values()) {
                    user.setTotal(top, random.nextInt(1000));
                }
                user.setMilestoneCount(random.nextInt(100));
                user.setPlayerName(playerName);
                user.updateName(true);
                ++num;
                this.plugin.debug("Generated user " + uuid.toString() + "/" + playerName);
            }
        }
    }

    private String getSaltString() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 12) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }

    public void testRewards(final int amount, final String name, final String rewardName) {
        this.plugin.getVoteTimer().submit(new Runnable(){

            @Override
            public void run() {
                long time1 = System.currentTimeMillis();
                ArrayList<Long> timesPerReward = new ArrayList<Long>();
                VotingPluginUser user = VoteTester.this.plugin.getVotingPluginUserManager().getVotingPluginUser(name);
                Reward reward = VoteTester.this.plugin.getRewardHandler().getReward(rewardName);
                int rewardsGiven = 0;
                for (int i = 0; i < amount; ++i) {
                    long start1 = System.currentTimeMillis();
                    if (reward.canGiveReward(user, new RewardOptions())) {
                        ++rewardsGiven;
                        VoteTester.this.plugin.getRewardHandler().giveReward((AdvancedCoreUser)user, reward, new RewardOptions().setIgnoreRequirements(true));
                    }
                    long start2 = System.currentTimeMillis();
                    timesPerReward.add(start2 - start1);
                }
                long time2 = System.currentTimeMillis();
                long time = time2 - time1;
                long timeTotal = 0L;
                for (Long t : timesPerReward) {
                    timeTotal += t.longValue();
                }
                long timePerRewardAvg = timeTotal / (long)timesPerReward.size();
                VotingPluginMain.plugin.getLogger().info("Time to process rewards (" + amount + "): " + time + " ms, average per reward " + timePerRewardAvg + " ms. " + (Object)((Object)VotingPluginMain.plugin.getStorageType()) + ", " + VoteTester.this.plugin.getVotingPluginUserManager().getAllUUIDs().size() + " users. " + rewardsGiven + " rewards given");
            }
        });
    }

    public void testSpam(int amount, final String name, final String site) {
        for (int i = 0; i < amount; ++i) {
            this.plugin.getBukkitScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    VoteTester.this.plugin.getVoteTimer().submit(new Runnable(){

                        @Override
                        public void run() {
                            PlayerVoteEvent voteEvent = new PlayerVoteEvent(VoteTester.this.plugin.getVoteSite(site, false), name, VoteTester.this.plugin.getVoteSiteServiceSite(site), false);
                            VoteTester.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
                        }
                    });
                }
            });
        }
    }

    public void testVotes(final int amount, final String name, final String site) {
        this.plugin.getVoteTimer().submit(new Runnable(){

            @Override
            public void run() {
                long time1 = System.currentTimeMillis();
                ArrayList<Long> timesPerVote = new ArrayList<Long>();
                for (int i = 0; i < amount; ++i) {
                    long start1 = System.currentTimeMillis();
                    PlayerVoteEvent voteEvent = new PlayerVoteEvent(VoteTester.this.plugin.getVoteSite(site, false), name, VoteTester.this.plugin.getVoteSiteServiceSite(site), false);
                    VoteTester.this.plugin.getServer().getPluginManager().callEvent((Event)voteEvent);
                    long start2 = System.currentTimeMillis();
                    timesPerVote.add(start2 - start1);
                }
                long time2 = System.currentTimeMillis();
                long time = time2 - time1;
                long timeTotal = 0L;
                for (Long t : timesPerVote) {
                    timeTotal += t.longValue();
                }
                long timePerVoteAvg = timeTotal / (long)timesPerVote.size();
                VotingPluginMain.plugin.getLogger().info("Time to process votes (" + amount + "): " + time + " ms, average per vote " + timePerVoteAvg + " ms. " + (Object)((Object)VotingPluginMain.plugin.getStorageType()) + ", " + VoteTester.this.plugin.getVotingPluginUserManager().getAllUUIDs().size() + " users. " + VoteTester.this.plugin.getVoteSitesEnabled().size() + " votesites");
            }
        });
    }
}

