/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.specialrewards;

import com.bencodez.votingplugin.VotingPluginMain;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardBuilder;
import com.bencodez.votingplugin.advancedcore.api.rewards.RewardOptions;
import com.bencodez.votingplugin.advancedcore.api.user.AdvancedCoreUser;
import com.bencodez.votingplugin.events.PlayerSpecialRewardEvent;
import com.bencodez.votingplugin.events.SpecialRewardType;
import com.bencodez.votingplugin.proxy.BungeeMessageData;
import com.bencodez.votingplugin.simpleapi.messages.MessageAPI;
import com.bencodez.votingplugin.topvoter.TopVoter;
import com.bencodez.votingplugin.user.VotingPluginUser;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Event;

public class SpecialRewards {
    private VotingPluginMain plugin;

    public SpecialRewards(VotingPluginMain plugin) {
        this.plugin = plugin;
    }

    public void bungeeAllSitesCheck(VotingPluginUser user, int numberOfVotes, int num) {
        int numberOfSites;
        if (this.plugin.getBungeeSettings().isGiveExtraAllSitesRewards() && numberOfVotes >= (numberOfSites = this.plugin.getVoteSitesEnabled().size()) * 2 && num > numberOfSites && num % numberOfSites == 0 && user.checkAllVotes()) {
            this.plugin.debug("Giving extra allsites reward from bungee");
            this.giveAllSitesRewards(user, user.isOnline(), true);
        }
    }

    public boolean checkAllSites(VotingPluginUser user, boolean forceBungee) {
        boolean checkAllVotes = user.checkAllVotes();
        if (checkAllVotes && (this.plugin.getConfigFile().isExtraAllSitesCheck() || this.plugin.getBungeeSettings().isUseBungeecoord())) {
            int day;
            int currentDay = LocalDateTime.now().getDayOfYear();
            if (currentDay == (day = user.getGottenAllSitesDay())) {
                checkAllVotes = false;
                this.plugin.debug("Not giving allsites, already gotten today");
            } else {
                user.setGottenAllSitesDay(currentDay);
            }
        }
        if (checkAllVotes) {
            this.giveAllSitesRewards(user, user.isOnline(), forceBungee);
        }
        return checkAllVotes;
    }

    public boolean checkAlmostAllSites(VotingPluginUser user, boolean forceBungee) {
        boolean checkAllVotes = user.checkAlmostAllVotes();
        this.plugin.extraDebug("Checking almostallsites reward: " + checkAllVotes + "/" + user.getSitesNotVotedOn());
        if (checkAllVotes) {
            int day;
            int currentDay = LocalDateTime.now().getDayOfYear();
            if (currentDay == (day = user.getGottenAlmostAllSitesDay())) {
                checkAllVotes = false;
                this.plugin.debug("Not giving almostallsites, already gotten today");
            } else {
                user.setGottenAlmostAllSitesDay(currentDay);
                this.giveAlmostAllSitesRewards(user, user.isOnline(), forceBungee);
            }
        }
        return checkAllVotes;
    }

    public boolean checkCumualativeVotes(VotingPluginUser user, BungeeMessageData bungeeMessageData, boolean forceBungee) {
        boolean gotCumulativeAny = false;
        Set<String> votes = this.plugin.getSpecialRewardsConfig().getCumulativeVotes();
        for (String vote : votes) {
            if (MessageAPI.isInt(vote)) {
                int votesRequired = Integer.parseInt(vote);
                if (votesRequired == 0 || !this.plugin.getSpecialRewardsConfig().getCumulativeRewardEnabled(votesRequired) || !this.plugin.getRewardHandler().hasRewards(this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getCumulativeRewardsPath(votesRequired))) continue;
                boolean gotCumulative = false;
                int total = 0;
                boolean useBungeeTotalNum = bungeeMessageData != null;
                String totalToUse = this.plugin.getSpecialRewardsConfig().getCumulativeVotesTotal(votesRequired);
                TopVoter top = TopVoter.getTopVoter(totalToUse);
                if (!useBungeeTotalNum) {
                    total = user.getTotal(top);
                } else {
                    switch (top) {
                        case AllTime: {
                            total = bungeeMessageData.getAllTimeTotal();
                            break;
                        }
                        case Daily: {
                            total = bungeeMessageData.getDailyTotal();
                            break;
                        }
                        case Monthly: {
                            if (this.plugin.getConfigFile().isUseMonthDateTotalsAsPrimaryTotal()) {
                                total = bungeeMessageData.getDateMonthTotal();
                                break;
                            }
                            total = bungeeMessageData.getMonthTotal();
                            break;
                        }
                        case Weekly: {
                            total = bungeeMessageData.getWeeklyTotal();
                            break;
                        }
                    }
                }
                List<Integer> blackList = this.plugin.getSpecialRewardsConfig().getCumulativeBlackList(votesRequired);
                boolean blackListed = false;
                for (Integer num : blackList) {
                    if (num != total) continue;
                    blackListed = true;
                    this.plugin.extraDebug("Not giving cumulative " + votesRequired + " to " + user.getPlayerName() + " due to blacklist");
                }
                if (this.plugin.getSpecialRewardsConfig().getCumulativeRecurring(votesRequired)) {
                    if (total != 0 && total >= votesRequired && total % votesRequired == 0 && !blackListed) {
                        gotCumulative = true;
                    }
                } else if (total == votesRequired) {
                    gotCumulative = true;
                }
                if (gotCumulative) {
                    if (!this.plugin.getSpecialRewardsConfig().isOnlyOneCumulative() || !gotCumulativeAny) {
                        gotCumulativeAny = true;
                        this.plugin.debug(user.getPlayerName() + " got cumulative " + votesRequired + ", total: " + top.toString() + ", current total: " + total);
                        this.giveCumulativeVoteReward(user, user.isOnline(), votesRequired, forceBungee);
                        continue;
                    }
                    this.plugin.debug("Already got one cumulative");
                    continue;
                }
                this.plugin.devDebug(user.getPlayerName() + " not able to get cumulative " + votesRequired + ", total required: " + top.toString() + ", current player total: " + total);
                continue;
            }
            this.plugin.debug("Invalid cumulative number: " + vote);
        }
        return gotCumulativeAny;
    }

    public boolean checkFirstVote(VotingPluginUser user, boolean forceBungee) {
        if (this.plugin.getRewardHandler().hasRewards(this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getFirstVoteRewardsPath()) && !user.hasGottenFirstVote()) {
            this.giveFirstVoteRewards(user, user.isOnline(), forceBungee);
            return true;
        }
        return false;
    }

    public boolean checkFirstVoteToday(VotingPluginUser user, boolean forceBungee) {
        if (this.plugin.getRewardHandler().hasRewards(this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getFirstVoteRewardsPath()) && !user.hasGottenFirstVoteToday()) {
            this.giveFirstVoteTodayRewards(user, user.isOnline(), forceBungee);
            return true;
        }
        return false;
    }

    public boolean checkMilestone(VotingPluginUser user, BungeeMessageData bungeeMessageData, boolean forceBungee) {
        int milestoneCount = user.getMilestoneCount();
        if (bungeeMessageData != null) {
            try {
                milestoneCount = bungeeMessageData.getMilestoneCount();
            }
            catch (Exception e) {
                e.printStackTrace();
                milestoneCount = user.getMilestoneCount();
            }
        }
        if (this.plugin.getConfigFile().isPreventRepeatMilestones()) {
            ArrayList<Integer> nums = new ArrayList<Integer>();
            for (String str : this.plugin.getSpecialRewardsConfig().getMilestoneVotes()) {
                try {
                    nums.add(Integer.parseInt(str));
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to get number from " + str);
                }
            }
            Iterator<String> iterator = nums.iterator();
            while (iterator.hasNext()) {
                int num = (Integer)((Object)iterator.next());
                if (milestoneCount <= num || user.hasGottenMilestone(num)) continue;
                this.plugin.getLogger().info("Milestone " + num + " for " + user.getPlayerName() + " not already given when it should be, Current AllTimeTotal: " + user.getTotal(TopVoter.AllTime) + ", Current MileStoneCount: " + user.getMilestoneCount());
                user.setHasGotteMilestone(num, true);
            }
        }
        boolean gotMilestone = false;
        Set<String> votes = this.plugin.getSpecialRewardsConfig().getMilestoneVotes();
        for (String vote : votes) {
            if (MessageAPI.isInt(vote)) {
                int votesRequired = Integer.parseInt(vote);
                if (votesRequired == 0) continue;
                if (this.plugin.getSpecialRewardsConfig().getMilestoneRewardEnabled(votesRequired) && this.plugin.getRewardHandler().hasRewards(this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getMilestoneRewardsPath(votesRequired))) {
                    int userVotesTotal = milestoneCount;
                    if (userVotesTotal < votesRequired || user.hasGottenMilestone(votesRequired)) continue;
                    this.giveMilestoneVoteReward(user, user.isOnline(), votesRequired, forceBungee);
                    user.setHasGotteMilestone(votesRequired, true);
                    this.plugin.debug(user.getPlayerName() + " got milestone " + votesRequired);
                    continue;
                }
                this.plugin.debug("Milestone " + votesRequired + " not enabled or has no rewards");
                continue;
            }
            this.plugin.debug("Invalid milestone number: " + vote);
        }
        return gotMilestone;
    }

    public boolean checkVoteStreak(VotingPluginUser user, String type, boolean forceBungee) {
        boolean gotReward = false;
        Set<String> streaks = this.plugin.getSpecialRewardsConfig().getVoteStreakVotes(type);
        for (String streak : streaks) {
            int streakRequired;
            boolean multiple = false;
            if (streak.contains("-")) {
                multiple = true;
            }
            String s = streak.replaceAll("-", "");
            this.plugin.debug("Streak: " + streak + " multiple: " + multiple);
            if (!MessageAPI.isInt(s) || (streakRequired = Integer.parseInt(s)) == 0 || !this.plugin.getSpecialRewardsConfig().getVoteStreakRewardEnabled(type, streak) || !this.plugin.getRewardHandler().hasRewards(this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getVoteStreakRewardsPath(type, "" + streak))) continue;
            int curStreak = 0;
            if (type.equalsIgnoreCase("day")) {
                curStreak = user.getDayVoteStreak();
            } else if (type.equalsIgnoreCase("week")) {
                curStreak = user.getWeekVoteStreak();
            } else if (type.equalsIgnoreCase("month")) {
                curStreak = user.getMonthVoteStreak();
            }
            if (!multiple) {
                if (curStreak != streakRequired) continue;
                this.giveVoteStreakReward(user, user.isOnline(), type, "" + streakRequired, curStreak, forceBungee);
                gotReward = true;
                this.plugin.debug(user.getPlayerName() + " got VoteStreak " + streakRequired + " for " + type);
                continue;
            }
            if (curStreak == 0 || curStreak % streakRequired != 0) continue;
            this.giveVoteStreakReward(user, user.isOnline(), type, streak, curStreak, forceBungee);
            gotReward = true;
            this.plugin.debug(user.getPlayerName() + " got VoteStreak " + streakRequired + "* for " + type);
        }
        return gotReward;
    }

    public void giveAllSitesRewards(VotingPluginUser user, boolean online, boolean forceBungee) {
        PlayerSpecialRewardEvent event = new PlayerSpecialRewardEvent(user, SpecialRewardType.ALLSITE);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.plugin.getRewardHandler().giveReward(user, (ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getAllSitesRewardPath(), new RewardOptions().setServer(forceBungee).setOnline(online));
    }

    public void giveAlmostAllSitesRewards(VotingPluginUser user, boolean online, boolean forceBungee) {
        PlayerSpecialRewardEvent event = new PlayerSpecialRewardEvent(user, SpecialRewardType.ALMOSTALLSITES);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.plugin.getRewardHandler().giveReward(user, (ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getAlmostAllSitesRewardPath(), new RewardOptions().setServer(forceBungee).setOnline(online));
    }

    public void giveCumulativeVoteReward(VotingPluginUser user, boolean online, int cumulative, boolean forceBungee) {
        PlayerSpecialRewardEvent event = new PlayerSpecialRewardEvent(user, SpecialRewardType.CUMMULATIVE.setAmount(cumulative));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        new RewardBuilder((ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getCumulativeRewardsPath(cumulative)).setServer(forceBungee).setOnline(online).withPlaceHolder("Cumulative", "" + cumulative).send((AdvancedCoreUser)user);
    }

    public void giveFirstVoteRewards(VotingPluginUser user, boolean online, boolean forceBungee) {
        PlayerSpecialRewardEvent event = new PlayerSpecialRewardEvent(user, SpecialRewardType.FIRSTVOTE);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.plugin.getRewardHandler().giveReward(user, (ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getFirstVoteRewardsPath(), new RewardOptions().setServer(forceBungee).setOnline(online));
    }

    public void giveFirstVoteTodayRewards(VotingPluginUser user, boolean online, boolean forceBungee) {
        PlayerSpecialRewardEvent event = new PlayerSpecialRewardEvent(user, SpecialRewardType.FIRSTVOTETODAY);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.plugin.getRewardHandler().giveReward(user, (ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getFirstVoteTodayRewardsPath(), new RewardOptions().setServer(forceBungee).setOnline(online));
    }

    public void giveMilestoneVoteReward(VotingPluginUser user, boolean online, int milestone, boolean forceBungee) {
        PlayerSpecialRewardEvent event = new PlayerSpecialRewardEvent(user, SpecialRewardType.MILESTONE.setAmount(milestone));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        new RewardBuilder((ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getMilestoneRewardsPath(milestone)).setOnline(online).withPlaceHolder("Milestone", "" + milestone).setServer(forceBungee).send((AdvancedCoreUser)user);
    }

    public void giveVoteStreakReward(VotingPluginUser user, boolean online, String type, String string, int votes, boolean forceBungee) {
        PlayerSpecialRewardEvent event = new PlayerSpecialRewardEvent(user, SpecialRewardType.VOTESTREAK.setType(type).setAmount(votes));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        new RewardBuilder((ConfigurationSection)this.plugin.getSpecialRewardsConfig().getData(), this.plugin.getSpecialRewardsConfig().getVoteStreakRewardsPath(type, string)).setOnline(online).withPlaceHolder("Type", type).setServer(forceBungee).withPlaceHolder("Streak", "" + votes).send((AdvancedCoreUser)user);
    }
}

