/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.updater;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.plugin.java.JavaPlugin;

public class Updater {
    private String oldVersion;
    private JavaPlugin plugin;
    private String RESOURCE_ID = "";
    private UpdateResult result = UpdateResult.DISABLED;
    private String version;

    public Updater(JavaPlugin plugin, Integer resourceId, boolean disabled) {
        this.RESOURCE_ID = resourceId + "";
        this.plugin = plugin;
        this.oldVersion = this.plugin.getDescription().getVersion();
        if (disabled) {
            this.result = UpdateResult.DISABLED;
            return;
        }
        this.run();
    }

    public UpdateResult getResult() {
        return this.result;
    }

    public String getVersion() {
        return this.version;
    }

    private void run() {
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.RESOURCE_ID).openConnection();
            int timed_out = 2000;
            connection.setConnectTimeout(timed_out);
            connection.setReadTimeout(timed_out);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            this.version = reader.readLine();
            connection.disconnect();
            reader.close();
            this.versionCheck();
            return;
        }
        catch (Exception e) {
            this.result = UpdateResult.FAIL_SPIGOT;
            this.result = UpdateResult.FAIL_SPIGOT;
            return;
        }
    }

    public boolean shouldUpdate(String localVersion, String remoteVersion) {
        return !localVersion.equalsIgnoreCase(remoteVersion);
    }

    private void versionCheck() {
        this.result = this.shouldUpdate(this.oldVersion, this.version) ? UpdateResult.UPDATE_AVAILABLE : UpdateResult.NO_UPDATE;
    }

    public static enum UpdateResult {
        BAD_RESOURCEID,
        DISABLED,
        FAIL_NOVERSION,
        FAIL_SPIGOT,
        NO_UPDATE,
        UPDATE_AVAILABLE;

    }
}

