/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.sql.sqlite.db;

import com.bencodez.votingplugin.simpleapi.sql.sqlite.Database;
import com.bencodez.votingplugin.simpleapi.sql.sqlite.db.Error;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class SQLite {
    private Connection connection;
    private String dbName;
    private String dir;
    private boolean inDF = true;
    private Plugin plugin;
    private String query;

    public SQLite(Plugin plugin, String dbName, Database db) {
        this.plugin = plugin;
        this.dbName = dbName;
        this.query = db.getTableQuery();
        this.connection = this.getSQLConnection();
    }

    public SQLite(Plugin instance, String dbName, Database db, String directory) {
        this.plugin = instance;
        this.dbName = dbName;
        this.query = db.getTableQuery();
        this.inDF = false;
        this.dir = directory;
        this.connection = this.getSQLConnection();
    }

    public void close(PreparedStatement ps, ResultSet rs) {
        try {
            if (ps != null) {
                ps.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException ex) {
            Error.close(this.plugin, ex);
        }
    }

    public void closeConnection() {
        try {
            if (!this.connection.isClosed()) {
                this.connection.close();
                this.connection = null;
            } else {
                this.connection = null;
            }
        }
        catch (Exception e) {
            Error.close(this.plugin, e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDir() {
        return this.dir;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getQuery() {
        return this.query;
    }

    public Connection getSQLConnection() {
        File file;
        if (this.inDF) {
            file = new File(this.plugin.getDataFolder(), this.dbName + ".db");
            this.plugin.getDataFolder().mkdirs();
        } else {
            new File(this.dir).mkdirs();
            file = new File(this.dir + "/" + this.dbName + ".db");
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "File write error: " + this.dbName + ".db");
            }
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + file);
            return this.connection;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "SQLite exception on initialize", ex);
        }
        catch (ClassNotFoundException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "You need the SQLite JBDC library. Google it. Put it in /lib folder.");
        }
        return null;
    }

    public boolean isInDF() {
        return this.inDF;
    }

    public void load() {
        this.connection = this.getSQLConnection();
        try {
            PreparedStatement s = this.connection.prepareStatement(this.query);
            s.executeUpdate();
            s.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

