/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.sql.sqlite;

import com.bencodez.votingplugin.simpleapi.sql.sqlite.Table;
import com.bencodez.votingplugin.simpleapi.sql.sqlite.db.SQLite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.plugin.Plugin;

public class Database {
    private SQLite sqLite;
    private List<Table> tables = new ArrayList<Table>();

    public Database(Plugin plugin, String dbName, Table table) {
        this.tables.add(table);
        this.sqLite = new SQLite(plugin, dbName, this);
        this.sqLite.load();
        table.setSqLite(this.sqLite);
    }

    public Database(Plugin plugin, String dbName, Table table, String file) {
        this.tables.add(table);
        this.sqLite = new SQLite(plugin, dbName, this, file);
        this.sqLite.load();
        table.setSqLite(this.sqLite);
    }

    public void addTable(Table table) {
        this.tables.add(table);
        table.setSqLite(this.sqLite);
        try {
            PreparedStatement statement = this.sqLite.getSQLConnection().prepareStatement(table.getQuery());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection() {
        return this.sqLite.getSQLConnection();
    }

    public SQLite getDB() {
        return this.sqLite;
    }

    public String getTableQuery() {
        return this.tables.get(0).getQuery();
    }

    public List<Table> getTables() {
        return this.tables;
    }
}

