/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.sql.mysql.queries;

import com.bencodez.votingplugin.simpleapi.sql.mysql.MySQL;
import com.bencodez.votingplugin.simpleapi.sql.mysql.queries.Callback;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class Query {
    private boolean addBatch = false;
    private Connection connection;
    private MySQL mysql;
    private HashMap<Integer, Object> paramters = new HashMap();
    private String sql;

    public Query(MySQL mysql, String sql) throws SQLException {
        this.mysql = mysql;
        this.sql = sql;
    }

    public void addBatch() throws SQLException {
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
        this.addBatch = true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        try (Connection conn = this.mysql.getConnectionManager().getConnection();){
            Object object;
            block16: {
                PreparedStatement sql = conn.prepareStatement(this.sql);
                try {
                    for (Map.Entry<Integer, Object> entry : this.paramters.entrySet()) {
                        sql.setObject(entry.getKey(), entry.getValue());
                    }
                    if (this.addBatch) {
                        sql.addBatch();
                    }
                    object = sql.executeBatch();
                    if (sql == null) break block16;
                }
                catch (Throwable throwable) {
                    if (sql != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sql.close();
            }
            return object;
        }
        catch (SQLException sQLException) {
            return new int[0];
        }
    }

    public void executeBatchAsync() {
        this.executeBatchAsync(null);
    }

    public void executeBatchAsync(final Callback<int[], SQLException> callback) {
        this.mysql.getThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        int[] rowsChanged = Query.this.executeBatch();
                        if (callback != null) {
                            callback.call(rowsChanged, null);
                        }
                    }
                    catch (SQLException e) {
                        if (callback == null) break block3;
                        callback.call(null, e);
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        try (Connection conn = this.mysql.getConnectionManager().getConnection();){
            int n;
            block18: {
                PreparedStatement sql = conn.prepareStatement(this.sql);
                try {
                    for (Map.Entry<Integer, Object> entry : this.paramters.entrySet()) {
                        sql.setObject(entry.getKey(), entry.getValue());
                    }
                    if (this.addBatch) {
                        sql.addBatch();
                    }
                    int num = sql.executeUpdate();
                    sql.close();
                    n = num;
                    if (sql == null) break block18;
                }
                catch (Throwable throwable) {
                    if (sql != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sql.close();
            }
            return n;
        }
        catch (SQLException e) {
            if (!e.getMessage().contains("Duplicate entry")) {
                this.mysql.severe("Failed to send query: " + this.sql);
                e.printStackTrace();
            } else {
                this.mysql.debug("Failed to send query: " + this.sql);
                this.mysql.debug(e);
            }
            return 0;
        }
    }

    public void executeUpdateAsync() {
        this.executeUpdateAsync(null);
    }

    public void executeUpdateAsync(final Callback<Integer, SQLException> callback) {
        this.mysql.getThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    int rowsChanged = Query.this.executeUpdate();
                    if (callback != null) {
                        callback.call(rowsChanged, null);
                    }
                }
                catch (SQLException e) {
                    if (callback != null) {
                        callback.call(0, e);
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public void rollback() throws SQLException {
        if (this.connection != null) {
            this.connection.rollback();
        }
    }

    public void setParameter(int index, Object value) throws SQLException {
        this.paramters.put(index, value);
    }
}

