/*
 * Decompiled with CFR 0.152.
 */
package com.bencodez.votingplugin.simpleapi.sql.mysql.queries;

import com.bencodez.votingplugin.simpleapi.sql.mysql.queries.QueryUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class InsertQuery {
    private LinkedHashMap<String, String> duplicateValues = new LinkedHashMap();
    private boolean onDuplicateKey = false;
    private String table;
    private LinkedHashMap<String, String> values = new LinkedHashMap();

    public InsertQuery(String table) {
        this.table = table;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ").append(this.table).append(" (").append(QueryUtils.separate(this.values.keySet(), ",")).append(")").append(" VALUES (").append(QueryUtils.separate(this.values.values(), ",")).append(")");
        if (this.onDuplicateKey) {
            builder.append(" ON DUPLICATE KEY UPDATE ");
            String separator = "";
            for (Map.Entry<String, String> entry : this.duplicateValues.entrySet()) {
                String column = entry.getKey();
                String value = entry.getValue();
                builder.append(separator).append(column).append("=").append(value);
                separator = ",";
            }
        }
        return builder.toString();
    }

    public InsertQuery onDuplicateKeyUpdate() {
        this.onDuplicateKey = true;
        return this;
    }

    public InsertQuery set(String column) {
        this.set(column, "VALUES(" + column + ")");
        return this;
    }

    public InsertQuery set(String column, String value) {
        this.duplicateValues.put(column, value);
        return this;
    }

    public InsertQuery value(String column) {
        this.value(column, "?");
        return this;
    }

    public InsertQuery value(String column, String value) {
        this.values.put(column, value);
        return this;
    }
}

